package com.braintree.command.request;

import de.hybris.platform.payment.dto.BillingInfo;
import de.hybris.platform.payment.dto.CardInfo;

import java.math.BigDecimal;
import java.util.Currency;


public class BrainTreeSaleTransactionRequest extends BrainTreeAuthorizationRequest {

    private BigDecimal taxAmount;
    private String customerFirstName;
    private String customerLastName;
    private String customerEmail;
    private String requestId;


    public BrainTreeSaleTransactionRequest(final String merchantTransactionCode, final CardInfo card,
        final Currency currency,
        final BigDecimal totalAmount, final BillingInfo shippingInfo) {
        super(merchantTransactionCode, card, currency, totalAmount, shippingInfo);
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(final BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getCustomerFirstName() {
        return customerFirstName;
    }

    public void setCustomerFirstName(final String customerFirstName) {
        this.customerFirstName = customerFirstName;
    }

    public String getCustomerLastName() {
        return customerLastName;
    }

    public void setCustomerLastName(final String customerLastName) {
        this.customerLastName = customerLastName;
    }

    public String getCustomerEmail() {
        return customerEmail;
    }

    public void setCustomerEmail(final String customerEmail) {
        this.customerEmail = customerEmail;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(final String requestId) {
        this.requestId = requestId;
    }
}
