package com.braintree.cart.service.impl;

import com.braintree.cart.dao.BrainTreeCartDAO;
import com.braintree.cart.service.BrainTreeCartService;
import de.hybris.platform.commerceservices.util.GuidKeyGenerator;
import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.servicelayer.model.ModelService;

/**
 * This class is a standard implementation of the BrainTreeCartService interface
 */
public class DefaultBrainTreeCartService implements BrainTreeCartService {

    private BrainTreeCartDAO brainTreeCartDao;
    private ModelService modelService;
    private GuidKeyGenerator guidKeyGenerator;

    @Override
    public CartModel getCartForPaymentId(String paymentId) {
        return brainTreeCartDao.getCartForPaymentId(paymentId);
    }

    @Override
    public void generateBrainTreeOrderId(AbstractOrderModel abstractOrderModel) {
        abstractOrderModel.setBrainTreeOrderId(guidKeyGenerator.generate().toString());
        modelService.save(abstractOrderModel);
    }

    public BrainTreeCartDAO getBrainTreeCartDao() {
        return brainTreeCartDao;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public void setGuidKeyGenerator(GuidKeyGenerator guidKeyGenerator) {
        this.guidKeyGenerator = guidKeyGenerator;
    }

    public void setBrainTreeCartDao(BrainTreeCartDAO brainTreeCartDao) {
        this.brainTreeCartDao = brainTreeCartDao;
    }
}
