package com.braintree.builders;

import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.dto.TransactionStatusDetails;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import org.joda.time.DateTime;

import java.math.BigDecimal;

public class PaymentTransactionEntryBuilder {

    private final PaymentTransactionType type;
    private CurrencyModel currency;
    private String transactionStatus = TransactionStatus.ACCEPTED.name();
    private String transactionStatusDetails = TransactionStatusDetails.SUCCESFULL.name();
    private String requestId;
    private String requestIdGraphQL;
    private BigDecimal amount;

    public PaymentTransactionEntryBuilder(PaymentTransactionType type) {
        this.type = type;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setCurrency(CurrencyModel currency) {
        this.currency = currency;
    }

    public void setTransactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setTransactionStatusDetails(String transactionStatusDetails) {
        this.transactionStatusDetails = transactionStatusDetails;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setRequestIdGraphQL(String requestIdGraphQL) {
        this.requestIdGraphQL = requestIdGraphQL;
    }

    public PaymentTransactionEntryModel getResult() {
        PaymentTransactionEntryModel paymentTransactionEntryModel = new PaymentTransactionEntryModel();
        paymentTransactionEntryModel.setType(this.type);
        paymentTransactionEntryModel.setCurrency(this.currency);
        paymentTransactionEntryModel.setTransactionStatus(this.transactionStatus);
        paymentTransactionEntryModel.setTransactionStatusDetails(this.transactionStatusDetails);
        paymentTransactionEntryModel.setRequestId(this.requestId);
        paymentTransactionEntryModel.setRequestIdGraphQL(this.requestIdGraphQL);
        paymentTransactionEntryModel.setTime(DateTime.now().toDate());
        paymentTransactionEntryModel.setAmount(this.amount);

        return paymentTransactionEntryModel;
    }
}
