package com.braintree.validators;

import com.braintree.enums.BraintreePageType;
import org.apache.log4j.Logger;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class BraintreeButtonTypeValidator implements Validator {

    private static final String INCORRECT_BUTTON_TYPE = "Incorrect buttonType parameter";
    private static final Logger LOG = Logger.getLogger(BraintreeButtonTypeValidator.class);

    @Override
    public boolean supports(Class<?> aClass) {
        return String.class.equals(aClass);
    }

    @Override
    public void validate(Object object, Errors errors) {
        final String buttonType = (String) object;
        try {
            BraintreePageType.valueOf(buttonType.toUpperCase());
        } catch (IllegalArgumentException exception) {
            LOG.error(exception.getMessage(), exception);
            errors.reject(buttonType, INCORRECT_BUTTON_TYPE);
        }
    }
}
