/**
 *
 */
package com.braintree.controllers;

import com.braintree.helper.BraintreeOrdersHelper;
import de.hybris.platform.commerceservices.request.mapping.annotation.RequestMappingOverride;
import de.hybris.platform.commercewebservicescommons.dto.order.OrderHistoryListWsDTO;
import de.hybris.platform.webservicescommons.cache.CacheControl;
import de.hybris.platform.webservicescommons.cache.CacheControlDirective;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdAndUserIdParam;
import de.hybris.platform.webservicescommons.swagger.ApiFieldsParam;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * This controller is used for displaying the list with OrderHistoryWsDTO.
 */
@Controller
@RequestMapping(value = "/{baseSiteId}")
@Tag(name = "Braintree Order history")
public class BraintreeOrderHistoryController extends BraintreeBaseCommerceController {

    @Resource(name = "braintreeOrdersHelper")
    private BraintreeOrdersHelper ordersHelper;

    @Secured({"ROLE_CUSTOMERGROUP", "ROLE_TRUSTED_CLIENT", "ROLE_CUSTOMERMANAGERGROUP"})
    @CacheControl(directive = CacheControlDirective.NO_CACHE)
    @RequestMapping(value = "/users/{userId}/orders", method = RequestMethod.GET)
    @RequestMappingOverride
    @ResponseBody
    @Operation(operationId = "getUserOrderHistory", summary = "Get order history for user.", description = "Returns order history data for all orders placed by a specified user for a specified base store. The response can display the results across multiple pages, if required.")
    @ApiBaseSiteIdAndUserIdParam
    public OrderHistoryListWsDTO getUserOrderHistory(
        @Parameter(description = "Filters only certain order statuses. For example, statuses=CANCELLED,CHECKED_VALID would only return orders with status CANCELLED or CHECKED_VALID.") @RequestParam(required = false) final String statuses,
        @Parameter(description = "The current result page requested.") @RequestParam(defaultValue = DEFAULT_CURRENT_PAGE) final int currentPage,
        @Parameter(description = "The number of results returned per page.") @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) final int pageSize,
        @Parameter(description = "Sorting method applied to the return results.") @RequestParam(required = false) final String sort,
        @ApiFieldsParam @RequestParam(defaultValue = DEFAULT_FIELD_SET) final String fields,
        final HttpServletResponse response) {
        validateStatusesEnumValue(statuses);

        final OrderHistoryListWsDTO orderHistoryList = ordersHelper
            .searchOrderHistory(statuses, currentPage, pageSize, sort, addPaginationField(fields));

        setTotalCountHeader(response, orderHistoryList.getPagination());

        return orderHistoryList;
    }

}
