package com.braintree.converters.populators;

import com.braintree.hybris.data.ws.BraintreeUsBankAccountBillingAddressWsDTO;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.RegionData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

public class BrainTreeUsBankAccountAddressPopulator implements Populator<BraintreeUsBankAccountBillingAddressWsDTO, AddressData> {

    @Override
    public void populate(BraintreeUsBankAccountBillingAddressWsDTO usBankAccountAddress, AddressData addressData) throws ConversionException {
        if (usBankAccountAddress.getBusinessName() != null) {
            addressData.setFirstName(usBankAccountAddress.getBusinessName());
        } else {
            addressData.setFirstName(usBankAccountAddress.getFirstName());
            addressData.setLastName(usBankAccountAddress.getLastName());
        }
        final CountryData usCountryData = new CountryData();
        usCountryData.setIsocode("US");
        addressData.setCountry(usCountryData);

        final RegionData region = new RegionData();
        region.setIsocode(addressData.getCountry().getIsocode() + "-" + usBankAccountAddress.getRegion());
        addressData.setRegion(region);

        addressData.setLine1(usBankAccountAddress.getStreetAddress());
        if (usBankAccountAddress.getExtendedAddress() != null) {
            addressData.setLine2(usBankAccountAddress.getExtendedAddress());
        }
        addressData.setPostalCode(usBankAccountAddress.getPostalCode());
        addressData.setTown(usBankAccountAddress.getLocality());
        addressData.setBillingAddress(Boolean.TRUE);
    }

}
