/**
 *
 */
package com.braintree.controllers;

import braintreehac.services.BrainTreeDropInConfigurationService;
import braintreehac.services.BrainTreeButtonConfigurationService;
import com.braintree.enums.BraintreePageType;
import com.braintree.facade.BrainTreeB2BOrderFacade;
import com.braintree.facade.impl.DefaultBrainTreeCheckoutFacade;
import com.braintree.hybris.data.ws.BraintreeButtonStyleWsDTO;
import de.hybris.platform.braintreehac.data.BraintreeButtonStyleData;
import de.hybris.platform.braintreehac.data.GooglePayButtonStyleData;
import de.hybris.platform.braintreehac.data.ApplePayButtonStyleData;
import com.braintree.hybris.data.PayPalCheckoutData;
import com.braintree.hybris.data.ws.BraintreeAssetsWsDTO;
import com.braintree.hybris.data.ws.DropInButtonStyleWsDTO;
import com.braintree.hybris.data.ws.PayPalCheckoutWsDTO;
import com.braintree.hybris.data.ws.PayPalButtonStyleWsDTO;
import com.braintree.validators.BraintreeButtonTypeValidator;
import de.hybris.platform.braintreehac.data.DropInButtonStyleData;
import de.hybris.platform.braintreehac.data.PayPalButtonStyleData;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdParam;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

import static braintreehac.services.BrainTreeDropInConfigurationService.CART;

@Controller
@RequestMapping(value = "/{baseSiteId}")
@Tag(name = "Braintree Payment")
public class BraintreePaymentController extends BraintreeBaseController {

    @Resource(name = "braintreeButtonTypeValidator")
    private BraintreeButtonTypeValidator buttonTypeValidator;

    @Resource(name = "brainTreeCheckoutFacade")
    private DefaultBrainTreeCheckoutFacade brainTreeCheckoutFacade;

    @Resource(name = "brainTreeButtonConfigurationService")
    private BrainTreeButtonConfigurationService brainTreeButtonConfigurationService;

    @Resource(name = "brainTreeDropInConfigurationService")
    private BrainTreeDropInConfigurationService dropInConfigurationService;

    @Resource(name = "brainTreeB2BOrderFacade")
    private BrainTreeB2BOrderFacade brainTreeB2BOrderFacade;

    @GetMapping("/users/{userId}/braintree/payment")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdParam
    @Operation(summary = " Get the Braintree data for client-side payment initialization",
        description = "Get a data for all payment methods")
    public PayPalCheckoutWsDTO getPaymentData(
        @Parameter(description = "Payment method identifier.", schema = @Schema(allowableValues = {
            "paypal", "googlepay", "venmo", "applepay", "localpayments", "creditcard", "configData", "full"}) , required = true) @RequestParam final String paymentMethod,
        @Parameter(description = "Page type", schema = @Schema(defaultValue = "MARK"))
        @RequestParam(defaultValue = "MARK", required = false) final String pageType) {
        final BraintreePageType braintreePageType = BraintreePageType.valueOf(pageType);
        final PayPalCheckoutData payPalCheckoutData = brainTreeCheckoutFacade.getPayPalCheckoutData(braintreePageType);
        payPalCheckoutData.getDropIn().setShowWarningMessageAboutReplenishmentDropIn(
            brainTreeB2BOrderFacade.isCustomerHasActiveReplenishmentForSavedPayPalOrCreditCard());
        return getDataMapper().map(payPalCheckoutData, PayPalCheckoutWsDTO.class, paymentMethod);
    }

    @GetMapping("/users/{userId}/braintree/payment/button")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdParam
    @Operation(description = " Get the PayPal Smart Button style data.")
    public BraintreeButtonStyleWsDTO getButtonStyle(
        @Parameter(description = "Button type identifier.", schema = @Schema(allowableValues = {"minicart", "cart", "mark"}),
            required = true) @RequestParam final String buttonType) {
        validate(buttonType, buttonType, buttonTypeValidator);
        final PayPalButtonStyleData payPalButtonStyleData = brainTreeButtonConfigurationService.
            getPayPalButtonStyleByPageType(BraintreePageType.valueOf(buttonType.toUpperCase()));
        final GooglePayButtonStyleData googlePayButtonStyleData = brainTreeButtonConfigurationService.
            getGooglePayButtonStyleByPageType(BraintreePageType.valueOf(buttonType.toUpperCase()));
        final ApplePayButtonStyleData applePayButtonStyleData = brainTreeButtonConfigurationService.
                getApplePayButtonStyleByPageType(BraintreePageType.valueOf(buttonType.toUpperCase()));

        BraintreeButtonStyleData braintreeButtonStyle = new BraintreeButtonStyleData();
        braintreeButtonStyle.setPayPalButtonStyle(payPalButtonStyleData);
        braintreeButtonStyle.setGooglePayButtonStyle(googlePayButtonStyleData);
        braintreeButtonStyle.setApplePayButtonStyle(applePayButtonStyleData);

        return getDataMapper().map(braintreeButtonStyle, BraintreeButtonStyleWsDTO.class);
    }

    @GetMapping("/braintree/payment/assets")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdParam
    @Operation(description = " Get assets for checkout.")
    public BraintreeAssetsWsDTO getAssets() {
        return getDataMapper().map(brainTreeCheckoutFacade.getBraintreeAssets(), BraintreeAssetsWsDTO.class);
    }


    @GetMapping("/users/{userId}/braintree/payment/dropInButton")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdParam
    @Operation(description = " Get the Drop-in UI button style data.")
    public DropInButtonStyleWsDTO getDropInButtonStyleb2b(
        @Parameter(description = "Button type identifier.", schema = @Schema(allowableValues = {"Cart", "Mini cart", "Billing"}),
            required = true) @RequestParam(required = false, defaultValue = CART) final String buttonType) {
        final DropInButtonStyleData dropInButtonStyleData = dropInConfigurationService.getDropInButtonStyleData(buttonType);
        final DropInButtonStyleWsDTO dropInButtonStyleWsDTO = getDataMapper()
            .map(dropInButtonStyleData, DropInButtonStyleWsDTO.class);
        return dropInButtonStyleWsDTO;
    }
}
