/**
 *
 */
package com.braintree.replenishment.service.impl;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.replenishment.dao.BraintreeCartToOrderCronJobDao;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.servicelayer.model.ModelService;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBrainTreeReplenishmentServiceTest {

    private static final String PAYMENT_METHOD_TOKEN = "TOKEN";
    @Mock
    private BraintreeCartToOrderCronJobDao cartToOrderCronJobDao;

    @Mock
    private ModelService modelService;

    @InjectMocks
    private DefaultBrainTreeReplenishmentService unit;


    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void disableReplenishmentCronJobByPaymentMethodTokenShouldSetActiveFalseForFoundedCronJobs() {
        final CartToOrderCronJobModel cronJobModel = Mockito.mock(CartToOrderCronJobModel.class);
        when(cartToOrderCronJobDao.findCronJobsByPaymentMethodToken(PAYMENT_METHOD_TOKEN))
            .thenReturn(Collections.singletonList(cronJobModel));

        unit.disableReplenishmentCronJobByPaymentMethodToken(PAYMENT_METHOD_TOKEN);
        verify(cronJobModel).setActive(Boolean.FALSE);
        verify(modelService).save(cronJobModel);
    }
}
