function configurePaypalShortcut(payPalButtonClass) {
    const isMiniCartCheckout = true;
    if (typeof braintree == 'undefined' || braintree === '') {
        addBrainTreeLibrary(() => createClientInstanceForPaypal(payPalButtonClass, isMiniCartCheckout));
    } else {
        createClientInstanceForPaypal(payPalButtonClass, isMiniCartCheckout);
    }
}

function createClientInstanceForPaypal(payPalButtonClass, isMiniCartCheckout) {
    createClientInstance(CONST.PAYPAL_EXPRESS_ERROR_ID, function () {
        if (dropInEnabled) {
            loadPayPalSDKForCreditMessage();
            initializeDropIn(createPayPalOtionsExpressCheckout(), isMiniCartCheckout);
        } else {
            initialisePaypal(payPalButtonClass, isMiniCartCheckout);
            initialiseGooglePay(isMiniCartCheckout);
            initialiseApplePay(isMiniCartCheckout);
            initializeSrc(isMiniCartCheckout);
        }
    });
}

function initialisePaypal(payPalButtonClass, isMiniCartCheckout) {
    createPayPalExpressCheckout(createPayPalOtionsExpressCheckout(), payPalButtonClass, isMiniCartCheckout);
}

function initialiseApplePay(isMiniCartCheckout) {
    if (isAvailableApplePay() && applePayEnabled) {
        disableApplePay();
        createApplePay(createPayPalOtionsExpressCheckout(), CONST.APPLE_PAY_BUTTON_SELECTOR, function (payload) {
            processApplePayResponseExpressCheckout(payload, isMiniCartCheckout);
        });
    } else {
        $(CONST.APPLE_PAY_BUTTON_CONTAINER).remove();
    }
}

function createPayPalOtionsExpressCheckout() {
    const paypalFlow = getPaypalFlow();

    var enableShippingAddressValue = JSON.parse(enableShippingAddress);
    var enableEditShippingAddress = shouldRenderPayPalChangePaymentButton
        || (!shouldShowShippingAddressMessage && (paypalIntent === CONST.INTENT_ORDER) && graphQLEnabled);

    var paypalOptions = {
        flow: paypalFlow,
        enableShippingAddress: JSON.parse(enableShippingAddress),
        enableBillingAddress: true,
        locale: braintreeLocale,
        shippingAddressEditable: !enableEditShippingAddress
    };

    if (paypalFlow === CONST.CHECKOUT_FLOW) {
        // configure paypal integration
        if (paypalIntent !== undefined && paypalIntent !== "") {
            paypalOptions.intent = paypalIntent;
        }
        if (shippingAddressOverride && (enableShippingAddressValue || enableEditShippingAddress)) {
            paypalOptions.shippingAddressOverride = {
                recipientName: recipientName,
                line1: streetAddress,
                line2: extendedAddress,
                city: locality,
                countryCode: countryCodeAlpha2,
                postalCode: postalCode,
                state: region,
                phone: phone
            }
        }
        if ((!shouldShowShippingAddressMessage && (paypalIntent === CONST.INTENT_ORDER) && graphQLEnabled)
            || (shouldRenderPayPalChangePaymentButton && shippingAddressOverride && deliveryAmount)) {
            paypalOptions.amount = (parseFloat(subtotal) + parseFloat(deliveryAmount)).toFixed(2);
        } else {
            paypalOptions.amount = amount;
        }
        paypalOptions.currency = currency;
        //configure pay later integration
        if ((creditEnabled || shouldRenderPayPalChangePaymentButton)
            && getStoreInVault()) {
            paypalOptions.requestBillingAgreement = true;
            paypalOptions.billingAgreementDetails = {
                description: billingAgreementDescription
            }
        }

    }
    else if (paypalFlow === CONST.VAULT_FLOW) {
        paypalOptions.billingAgreementDescription = billingAgreementDescription;
    }

    // configure display name for paypal connection
    if (typeof dbaName != 'undefined' && dbaName !== '') {
        if (dbaName.indexOf('*') > -1) {
            paypalOptions.displayName = dbaName.substr(0, dbaName.indexOf('*'));
        }
    }
    return paypalOptions;
}
