
function createHostedFields() {
    braintree.hostedFields.create({
            client: client,
            styles: {
                // Styling element state
                ":focus": {
                    "color": "blue"
                },
                ".valid": {
                    "color": "green"
                },
                ".invalid": {
                    "color": "red"
                }
            },
            fields: {
                cardholderName: {
                  container: '#cardholderName'
                },
                number: {
                  container: CONST.NUMBER_ID
                },
                expirationDate: {
                  container: CONST.EXPIRATION_DATE_ID,
                  placeholder: "MM/YY"
                },
                cvv: {
                  container: CONST.CVV_ID
                }
            }
        },
        function (hostedFieldsErr, hostedFieldsInstance) {
            if (hostedFieldsErr) {
                $("#submit_silentOrderPostForm").removeAttr("disabled");
                handleClientError(hostedFieldsErr);
                return;
            }

            $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).unbind(EVENTS.CLICK);
            // Add a click event listener to PayPal image
            const tokenizeOptions = {
              authenticationInsight: {
                merchantAccountId: currencyMerchantAccountId
              }
            };
            $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).click(function () {
                // initialize paypal authorization
                $("#submit_silentOrderPostForm").attr("disabled", true);
                hostedFieldsInstance.tokenize(tokenizeOptions, function (tokenizeErr, payload) {
                    if (tokenizeErr) {
                        $("#submit_silentOrderPostForm").removeAttr("disabled");
                        handleClientError(tokenizeErr)
                    } else {
                        if (is3DSecureShouldBePerformed(payload)) {
                            verify3DSecure(client, payload);
                        } else {
                            processResponce(payload);
                        }
                    }
                });
            });
        }
    );
}

function is3DSecureShouldBePerformed(payload) {
  var is3DSecureTurnOn = is3DSecureEnabled() || isSecure3dFallbackEnabled(payload);
  if (pageType !== 'undefined') {
    if (pageType === 'account') {
        return is3DSecureTurnOn && is3DSecureOnMyAccountEnabled();
    } else if (pageType === 'billing') {
        return is3DSecureTurnOn;
    }
  }
  return false;
}

function initialise3dSecure(e){
    e.preventDefault();
    var paymentMethodId = $(e.target).find('input[name="selectedPaymentMethodId"]').val();
    var paymentMethod = $(e.target).find('input[name="selectedPaymentMethod"]').val();
    if (!($.parseJSON(secure3d) || secure3dFallback) || paymentMethod === "PayPal" || paymentMethod === 'notFor3DSecure') {
        e.currentTarget.submit();
    }

    var processUrl = ACC.config.encodedContextPath + '/braintree/checkout/hop/getNewNonce';
    var params = {
      "paymentMethodId": paymentMethodId
    };
    $.get(processUrl, params)
    .then((paymentNonceResponse) => {

      if($.parseJSON(secure3d) || paymentNonceResponse.shouldPerform3dSecure) {

        braintree.client.create({
          authorization: clientToken
        }, function (clientErr, clientInstance) {

          if (clientErr) {
            $("#submit_silentOrderPostForm").removeAttr("disabled");
            handleClientError(clientErr);
            return;
          }
          braintree.threeDSecure.create({
            version: 2,
            client: clientInstance
          }, function (err, threeDSecure) {
            requestAdditionalFields(threeDSecure, paymentNonceResponse, e)
          });
        });

      } else {
        if (verifyFlow === true && paymentMethod === "creditCardPaymentMethod") {
          verifyCVV(e);
        } else {
          e.currentTarget.submit();
        }
      }

    });

    return false;
}

function verify3DSecure(clientInstance, paymentResponse) {
    braintree.threeDSecure.create({
        version: 2,
        client: clientInstance
    }, function (err, threeDSecure) {
        if (pageType !== 'undefined' && pageType === 'account') {
            requestAddressFieldsByAddressId(threeDSecure, paymentResponse);
        } else {
            requestAdditionalFields(threeDSecure, paymentResponse);
        }
    });
}

function requestAdditionalFields(threeDSecure, paymentResponse, e){
  var additionalInfoUrl = ACC.config.encodedContextPath + '/braintree/checkout/hop/getAdditionalInfo';
  $.get(additionalInfoUrl)
    .then((additionalInformation) => perform3DS(threeDSecure, paymentResponse, additionalInformation, e));
}

function requestAddressFieldsByAddressId(threeDSecure, paymentResponse, e){
    var addressByIdUrl = ACC.config.encodedContextPath + '/my-account/receive-address'
    var params = {
        "selectedAddressCode": deliveryAddressId
    };
    $.get(addressByIdUrl, params)
        .then((address) => perform3DS(threeDSecure, paymentResponse, $.parseJSON(address), e));
}

function perform3DS(threeDSecure, paymentResponse, address, e){
    var data = get3DSVerificationData(paymentResponse, address);
    if (pageType === 'account') {
        data = get3DSVerificationDataForMyAccountPage(paymentResponse, address);
    }
    console.log(JSON.stringify(data))
  threeDSecure.verifyCard(data,
    function (error, response) {
      if (error) {
          $("#submit_silentOrderPostForm").removeAttr("disabled");
          $("button[id^='useSelectedPaymentMethod']").removeAttr("disabled");
          showGlobalErrorMessage(error);
          return;
      }
      // 3DSecure finished, add 3DSecure returned nonce
      var liabilityShifted = response.liabilityShifted;
      var liabilityShiftPossible = response.liabilityShiftPossible;
      // allow process card if 3dSecureLiabilityResult is
      // skipped by merchant
      if (liabilityShifted || JSON.parse(skip3dSecureLiabilityResult) || !liabilityShiftPossible) {
          if(e !== undefined){
            $(e.target).find('input[name="selectedPaymentMethodNonce"]').val(response.nonce);
            $(e.target).find('input[name="is3dSecureFlow"]').val('true');

            if (verifyFlow) {
              verifyCVV(e);
            } else {
              e.currentTarget.submit();
            }
          }else{
            paymentResponse.nonce = response.nonce;
            paymentResponse.liabilityShifted = liabilityShifted;
            paymentResponse.liabilityShiftPossible = liabilityShiftPossible;
            paymentResponse.is3dSecureFlow = true;
            processResponce(paymentResponse);
          }
      } else {
          $("#submit_silentOrderPostForm").removeAttr("disabled");
          $("button[id^='useSelectedPaymentMethod']").removeAttr("disabled");
          showGlobalErrorMessage(ACC.addons.braintreeb2baddon['braintree.message.unsecured.card']);
      }

    }
  );
}

function getBillingAddressFor3DS(address){
  var billingAddress = {};
  if(address === undefined){
    var givenName = document.getElementById('address.firstName');
    var surname = document.getElementById('address.surname');
    var phoneNumber = document.getElementById('address.phone');
    var streetAddress = document.getElementById('address.line1');
    var extendedAddress = document.getElementById('address.line2');
    var locality = document.getElementById('address.townCity');
    var region = document.getElementById('address.region');
    var postalCode = document.getElementById('address.postcode');
    var countryCodeAlpha2 = document.getElementById('address.country');

    if(givenName !== null){
      billingAddress.givenName = givenName.value;
    }
    if(surname !== null){
      billingAddress.surname = surname.value;
    }
    if(phoneNumber !== null){
      billingAddress.phoneNumber = phoneNumber.value;
    }
    if(streetAddress !== null){
      billingAddress.streetAddress = streetAddress.value;
    }
    if(extendedAddress !== null){
      billingAddress.extendedAddress = extendedAddress.value;
    }
    if(locality !== null){
      billingAddress.locality = locality.value;
    }
    if(region !== null){
      billingAddress.region = region.value;
    }
    if(postalCode !== null){
      billingAddress.postalCode = postalCode.value;
    }
    if(countryCodeAlpha2 !== null){
      billingAddress.countryCodeAlpha2 = countryCodeAlpha2.value;
    }
  } else {
    billingAddress.givenName = address.firstName;
    billingAddress.surname = address.lastName;
    billingAddress.phoneNumber = address.phone;
    billingAddress.streetAddress = address.line1;
    billingAddress.extendedAddress = address.line2;
    billingAddress.locality = address.town;
    billingAddress.postalCode = address.postalCode;
    billingAddress.countryCodeAlpha2 = address.country.isocode;
    if (address.region !== null){
      billingAddress.region = address.region.isocodeShort;
    }
  }

  return billingAddress;
}

function get3DSVerificationDataForMyAccountPage(paymentResponse, address){
    var data =  {
        onLookupComplete: function (data, next) {
            next();
        },
        amount: amount,
        nonce: paymentResponse.nonce,
        bin: paymentResponse.details.bin,
        addFrame: (err, iframe) => addFrameFunction(err, iframe),
        removeFrame: function () {
            ACC.colorbox.close();
        },
        billingAddress: {
            givenName: address.firstName,
            surname: address.lastName,
            phoneNumber: address.phone,
            streetAddress: address.line1,
            extendedAddress: address.line2,
            locality: address.town,
            postalCode: address.postalCode,
            countryCodeAlpha2: address.country?.isocode
        }
  }

  return data;
}

function get3DSVerificationData(paymentResponse, additionalInformation){
  var data =  {
    onLookupComplete: function (data, next) {
        next();
    },
    amount: amount,
    nonce: paymentResponse.nonce,
    bin: paymentResponse.details.bin,
    addFrame: (err, iframe) => addFrameFunction(err, iframe),
    removeFrame: function () {
        ACC.colorbox.close();
    },
    billingAddress: getBillingAddressFor3DS(paymentResponse.billingAddress),
  }

  if(additionalInformation !== null){
    data.email = additionalInformation.email;
    data.additionalInformation = {
      workPhoneNumber: additionalInformation.phone,
      shippingGivenName: additionalInformation.firstName,
      shippingSurname: additionalInformation.lastName,
      shippingPhone: additionalInformation.phone,
      shippingAddress: {
        streetAddress: additionalInformation.line1,
        extendedAddress: additionalInformation.line2,
        locality: additionalInformation.town,
        region: additionalInformation.region,
        postalCode: additionalInformation.postalCode,
        countryCodeAlpha2: additionalInformation.country.isocode
      }
    }
    if(additionalInformation.region !== null){
      data.additionalInformation.shippingAddress.region = additionalInformation.region.isocodeShort;
    }
  }

  return data;
}

function addFrameFunction(err, iframe) {
    const threeDSContainer = $(HTML.DIV);
    $(threeDSContainer).append(iframe);
    ACC.colorbox.open("", {
        inline: true,
        href: threeDSContainer,
        onComplete: function () {
            $(this).colorbox.resize();
        }
    });
}

function verifyCVV(e) {

    //Closing box with saved payment methods
    const boxWithSavedPaymentMethods = $("#cboxClose")[0];
    boxWithSavedPaymentMethods.dispatchEvent(new CustomEvent('click'));

    //Hide all elements into Payment & Billing Address step
    const checkoutIndentElement = $(".checkout-indent")[0];
    checkoutIndentElement.style.display = 'none';

    //Show block for verifying cvv for hosted fields
    const verifyingCvvElement = $("#verifying-cvv")[0];
    verifyingCvvElement.classList.remove('bt-display-none');

    //Show selected payment method for CVV verification
    const paymentMethodId = $(e.target).find('input[name="selectedPaymentMethodId"]').val();
    const selectedPaymentMethodForCVVVerification = $("#paymentMethodVerification" + paymentMethodId)[0];
    selectedPaymentMethodForCVVVerification.classList.remove('bt-display-none');

    braintree.hostedFields.create({
        client: client,
        fields: {
            cvv: {
                selector: '#verify-cvv'
            }
        }
    }, function (err, hostedFieldsInstance) {

        if (err) {
            console.error(err);
            return;
        }

        const verifyCvvButton = $("#verify-cvv-button")[0];
        verifyCvvButton.addEventListener('click', function () {

            hostedFieldsInstance.tokenize(function (err, payload) {

                if (err) {
                    console.error(err);
                    showCustomAbsoluteErrorMessage(ACC.addons.braintreeb2baddon['braintree.message.invalid.cvv.card']);
                    return;
                }

                disabledButtons();
                $(e.target).find('input[name="selectedPaymentMethodCvvNonce"]').val(payload.nonce);
                e.currentTarget.submit();
            });
        });
    });
}

function disabledButtons() {
    $("input[id^='verify-cvv-button']").attr("disabled", true);
    $("input[id^='verify-cvv-cancel-button']").attr("disabled", true);
}