<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="template" tagdir="/WEB-INF/tags/responsive/template" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="multiCheckout" tagdir="/WEB-INF/tags/responsive/checkout/multi" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="formElement" tagdir="/WEB-INF/tags/responsive/formElement" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="address" tagdir="/WEB-INF/tags/responsive/address" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags" %>
<%@ taglib prefix="util" tagdir="/WEB-INF/tags/addons/braintreeb2baddon/responsive/util" %>
<%@ taglib prefix="importCheckoutData" tagdir="/WEB-INF/tags/addons/braintreeb2baddon/responsive/util/pages" %>
<%@ taglib prefix="fragments" tagdir="/WEB-INF/tags/addons/braintreeb2baddon/responsive/custom/fragments" %>

<jsp:include page="../../../../messages/braintreeErrorMessages.jsp"/>

<c:url value="${currentStepUrl}" var="choosePaymentMethodUrl"/>
<template:page pageTitle="${pageTitle}" hideHeaderLinks="true">
    <div class="row">
        <div class="col-sm-12" id="globalMessages"></div>
        <div class="col-sm-6">
            <div class="checkout-headline">
                <span class="glyphicon glyphicon-lock"></span>
                <spring:theme code="checkout.multi.secure.checkout"/>
            </div>
            <multiCheckout:checkoutSteps checkoutSteps="${checkoutSteps}" progressBarId="${progressBarId}">
                <jsp:body>
                    <c:choose>
                        <c:when test="${payPalCheckoutData.dropIn.dropInEnabled}">
                            <div class="checkout-paymentmethod">
                                <div class="checkout-indent">

                                    <div class="headline"><spring:theme code="checkout.multi.paymentMethod"/></div>
                                    <div class="no-payment-methods-message headline hidden"><spring:theme
                                            code="checkout.multi.paymentMethod.noPaymentMethods"/></div>

                                    <ycommerce:testId code="paymentDetailsForm">
                                        <form:form id="braintree-payment-form" name="silentOrderPostForm"
                                                   class="create_update_payment_form"

                                                   modelAttribute="sopPaymentDetailsForm"
                                                   action="${request.contextPath}/braintree/checkout/hop/response"
                                                   method="POST">
                                            <div id="dropin-container"></div>
                                            <div class="billingAddressData hidden">

                                                <div class="headline clear">
                                                    <spring:theme
                                                            code="checkout.multi.paymentMethod.addPaymentDetails.billingAddress"/>
                                                </div>

                                                <c:if test="${cartData.deliveryItemsQuantity > 0}">
                                                    <div id="useDeliveryAddressData"
                                                         data-firstname="${deliveryAddress.firstName}"
                                                         data-lastname="${deliveryAddress.lastName}"
                                                         data-line1="${deliveryAddress.line1}"
                                                         data-line2="${deliveryAddress.line2}"
                                                         data-town="${deliveryAddress.town}"
                                                         data-postalcode="${deliveryAddress.postalCode}"
                                                         data-countryisocode="${deliveryAddress.country.isocode}"
                                                         data-regionisocode="${deliveryAddress.region.isocodeShort}"
                                                         data-address-id="${deliveryAddress.id}"></div>
                                                    <formElement:formCheckbox path="useDeliveryAddress"
                                                                              idKey="useDeliveryAddress"
                                                                              labelKey="checkout.multi.sop.useMyDeliveryAddress"
                                                                              tabindex="11"/>
                                                </c:if>

                                                <input type="hidden" name="paypal_email" id="paypal_email"/>
                                                <input type="hidden"
                                                       value="${silentOrderPageData.parameters['billTo_email']}"
                                                       class="text" name="billTo_email" id="billTo_email">
                                                <address:billAddressFormSelector
                                                        supportedCountries="${countries}" regions="${regions}"
                                                        tabindex="12"/>
                                            </div>
                                        </form:form>
                                    </ycommerce:testId>
                                    <c:if test="${payPalCheckoutData.dropIn.dropInEnabled
                                        and (payPalCheckoutData.applePayPaymentMethod.applePayEnabled
                                        or payPalCheckoutData.googlePayPaymentMethod.googlePayEnabled
                                        or payPalCheckoutData.payPalPaymentMethod.payPalStandardEnabled
                                        or payPalCheckoutData.creditCardPaymentMethod.hostedFieldsEnable
                                        or payPalCheckoutData.venmoPaymentMethod.venmoEnabled)}">
                                        <button id="submit-button" class="btn btn-primary btn-block btn--continue-checkout"><spring:theme
                                                code="text.dropin.button.purchase"/></button>
                                    </c:if>

                                </div>
                            </div>
                        </c:when>
                        <c:otherwise>
                            <div class="checkout-paymentmethod">
                                <div class="checkout-indent">

                                    <div class="headline"><spring:theme code="checkout.multi.paymentMethod"/></div>
                                    <div class="no-payment-methods-message headline hidden"><spring:theme code="checkout.multi.paymentMethod.noPaymentMethods"/></div>

                                    <c:choose>
                                        <c:when test="${payPalCheckoutData.applePayPaymentMethod.applePayEnabled}">
                                            <div style="overflow: auto;" id="applepay" class="hide">
                                                <input id="paymentMethodApplePay" type="radio"
                                                       name="paymentMethodSelection" value="applePay"
                                                       class="paypalselection"/>
                                                <div class="applepay-image-container" id="applepay-container">
                                                    <div class="cmsimage">
                                                        <img class="apple-pay-image"
                                                             src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/apple-pay.png"
                                                             alt="Buy with ApplePay" class="payment-logo"/>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                        </c:when>
                                        <c:otherwise>
                                            <div style="overflow: auto;"></div>
                                        </c:otherwise>
                                    </c:choose>
                                    <c:choose>
                                        <c:when test="${payPalCheckoutData.googlePayPaymentMethod.googlePayEnabled}">
                                            <div style="overflow: auto;" id="googlepay" class="hide">
                                                <input id="paymentMethodGooglePay" type="radio"
                                                       name="paymentMethodSelection" value="googlePay"
                                                       class="paypalselection"/>
                                                <div id="google-pay-button-container">
                                                    <div class="cmsimage">
                                                        <img class="google-pay-image"
                                                             src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/googlePay_mark.png"
                                                             alt="Buy with GooglePay" class="payment-logo"/>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                        </c:when>
                                        <c:otherwise>
                                            <div style="overflow: auto;"></div>
                                        </c:otherwise>
                                    </c:choose>
                                    <c:choose>
                                        <c:when test="${payPalCheckoutData.payPalPaymentMethod.payPalStandardEnabled}">
                                            <div style="overflow: auto;" id="paypal-checkbox">
                                                <input id="paymentMethodPayPal" type="radio"
                                                       name="paymentMethodSelection" value="paypal"
                                                       class="paypalselection" checked="true"/>
                                                <div class="paypalimage" id="paypal-container">
                                                    <div class="cmsimage">
                                                        <img src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-medium.png"
                                                             alt="Buy now with PayPal" class="payment-logo"/>
                                                    </div>
                                                </div>
                                                <div id="text" class="paypalurl">
                                                    <a style="padding-left: 10px;"
                                                       href="https://www.paypal.com/webapps/mpp/paypal-popup"
                                                       title="How PayPal Works"
                                                       onclick="javascript:window.open('https://www.paypal.com/webapps/mpp/paypal-popup','WIPaypal','toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=1060, height=700'); return false;"><spring:theme
                                                            code="braintree.text.what.is.paypal"/>?</a>
                                                </div>
                                            </div>
                                            <br>
                                        </c:when>
                                        <c:otherwise>
                                            <div style="overflow: auto;"></div>
                                        </c:otherwise>
                                    </c:choose>
                                    <c:choose>
                                        <c:when test="${payPalCheckoutData.creditCardPaymentMethod.hostedFieldsEnable}">
                                            <div style="overflow: auto;" id="braintree-container">
                                                <input id="creditCardPaymentMethod" type="radio"
                                                       name="paymentMethodSelection" value="bt"
                                                       class="paypalselection"/>
                                                <c:if test="${not empty payPalCheckoutData.creditCardPaymentMethod.paymentsImagesUrl}">
                                                    <c:forEach items="${payPalCheckoutData.creditCardPaymentMethod.paymentsImagesUrl}" var="url">
                                                        <img src="${url.value}" alt="${url.key}"/>
                                                    </c:forEach>
                                                </c:if>
                                                <input type="hidden" value="false" class="text"
                                                       name="paypal_is_valid" id="paypal_is_valid">
                                            </div>
                                            <br>
                                        </c:when>
                                        <c:otherwise>
                                            <div style="overflow: auto;"></div>
                                        </c:otherwise>
                                    </c:choose>
                                    <c:choose>
                                        <c:when test="${payPalCheckoutData.localPaymentMethod.localPaymentMethodsEnabled && !empty payPalCheckoutData.localPaymentMethod.localPaymentMethods}">
                                            <div style="overflow: auto;" id="localpayments">
                                                <input id="paymentMethodLpm" type="radio"
                                                       name="paymentMethodSelection" value="lpm"
                                                       class="paypalselection"/>
                                                <div class="lpm-radio">
                                                    <label>Buy with Local Payment Method</label>
                                                </div>
                                            </div>
                                        </c:when>
                                        <c:otherwise>
                                            <div style="overflow: auto;"></div>
                                        </c:otherwise>
                                    </c:choose>
                                    <c:choose>
                                        <c:when test="${payPalCheckoutData.usBankAccountPaymentMethod.usBankAccountEnabled}">
                                            <div style="overflow: auto;" id="usBankAccount">
                                                <input id="paymentMethodUsBankAccount" type="radio"
                                                       name="paymentMethodSelection" value="usBankAccount"
                                                       class="paypalselection"/>
                                                <div id="us-bank-account-mark-container">
                                                    <div class="cmsimage">
                                                        <img class="us-bank-account-mark payment-logo"
                                                             src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/us_bank_account_acceptance_mark.png"
                                                             alt="Us Bank Account" />
                                                    </div>
                                                </div>
                                            </div>
                                        </c:when>
                                        <c:otherwise>
                                            <div style="overflow: auto;"></div>
                                        </c:otherwise>
                                    </c:choose>
                                    <c:choose>
                                        <c:when test="${payPalCheckoutData.venmoPaymentMethod.venmoEnabled}">
                                            <div style="overflow: auto;" id="venmo" class="hide">
                                                <input id="paymentMethodVenmo" type="radio"
                                                       name="paymentMethodSelection" value="venmo"
                                                       class="paypalselection"/>
                                                <div id="venmo-mark-container">
                                                    <div class="cmsimage">
                                                        <img class="venmo-mark payment-logo"
                                                             src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/venmo_acceptance_mark.svg"
                                                             alt="Venmo" />
                                                    </div>
                                                </div>
                                            </div>

                                        </c:when>
                                        <c:otherwise>
                                            <div style="overflow: auto;"></div>
                                        </c:otherwise>
                                    </c:choose>
                                    <c:choose>
                                        <c:when test="${payPalCheckoutData.srcPaymentMethod.srcEnabled}">
                                            <div style="overflow: auto;" id="src">
                                                <input id="paymentMethodSrc" type="radio"
                                                       name="paymentMethodSelection" value="src"
                                                       class="paypalselection"/>
                                                <div id="src-button-container">
                                                    <div class="src-radio">
                                                        <label>
                                                            Buy with Secure Remote Commerce
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </c:when>
                                        <c:otherwise>
                                            <div style="overflow: auto;"></div>
                                        </c:otherwise>
                                    </c:choose>

                                    <ycommerce:testId code="paymentDetailsForm">

                                        <form:form id="braintree-payment-form" name="silentOrderPostForm"
                                                   class="create_update_payment_form"

                                                   modelAttribute="sopPaymentDetailsForm"
                                                   action="${request.contextPath}/braintree/checkout/hop/response"
                                                   method="POST">

                                            <div id="venmo-button" class="venmo-container hide">
                                                <img src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/venmo_button.svg"
                                                     alt="venmo logo" class="venmo-button-style"/>
                                            </div>

                                            <div class="hostedFields">
                                                <div class="headline">
                                                    <spring:theme
                                                            code="checkout.multi.paymentMethod.addPaymentDetails.paymentCard"/>
                                                </div>
                                                <div class="description">
                                                    <spring:theme
                                                            code="checkout.multi.paymentMethod.addPaymentDetails.enterYourCardDetails"/>
                                                </div>
                                                <div class="control-group cardForm" style="dispaly: none;" id="cardForn">
                                                    <label for="cardholderName" class="control-label ">
                                                        <spring:theme code="braintree.text.cc.cardholder"/>
                                                    </label>
                                                    <div class="controls">
                                                        <div id="cardholderName"></div>
                                                    </div>
                                                    <label for="number" class="control-label ">
                                                        <spring:theme code="braintree.text.cc.number"/></label>
                                                    <div id="number" class="controls"></div>
                                                    <label for="cvv" class="control-label "><spring:theme
                                                            code="braintree.text.cc.cvv"/></label>
                                                    <div id="cvv" class="controls"></div>
                                                    <label for="expiration-date" class="control-label "><spring:theme
                                                            code="braintree.text.cc.expiration.date"/></label>
                                                    <div id="expiration-date" class="controls"></div>
                                                </div>
                                            </div>
                                            <br/>
                                            <div id="savePaymentButton">
                                                <c:if test="${not empty braintreePaymentInfos}">
                                                    <div class="form-group">
                                                        <button type="button" class="btn btn-default btn-block js-saved-payments">
                                                            <spring:theme
                                                                    code="checkout.multi.paymentMethod.addPaymentDetails.useSavedPaymentMethod"/>
                                                        </button>
                                                    </div>
                                                </c:if>
                                            </div>

                                            <div id="us-bank-account-container" class="paypal_button_container">
                                                <div class="headline">
                                                    <h4><spring:theme code="usBankAccount.ach.direct.debit"/></h4>
                                                </div>
                                                <div class="description">
                                                    <h5><spring:theme code="usBankAccount.enter.details"/></h5>
                                                </div>
                                                <div>
                                                    <label for="account-number"><spring:theme code="usBankAccount.account.number"/></label><br>
                                                    <input id="account-number" class="text form-control us-bank-account-fields" name="account-number" type="text" maxlength="17"><br>
                                                </div>
                                                <div>
                                                    <label for="routing-number"><spring:theme code="usBankAccount.routing.number"/></label><br>
                                                    <input id="routing-number" class="text form-control us-bank-account-fields" name="routing-number" type="text" maxlength="9"><br>
                                                </div>
                                                <div>
                                                    <label for="account-type"><spring:theme code="usBankAccount.account.type"/></label><br>
                                                    <select id="account-type" class="form-control us-bank-account-fields" name="account-type" >
                                                        <option value="checking" selected="selected">Checking</option>
                                                        <option value="savings">Savings</option>
                                                    </select><br>
                                                </div>
                                                <div>
                                                    <label for="ownership-type"><spring:theme code="usBankAccount.ownership.type"/></label><br>
                                                    <select id="ownership-type" class="form-control us-bank-account-fields" name="ownership-type" onchange="showPersonalOrBusinessField(value)">
                                                        <option value="personal" selected="selected">Personal</option>
                                                        <option value="business">Business</option>
                                                    </select><br>
                                                </div>
                                                <div id="first-and-last-name-container">
                                                    <label for="first-name"><spring:theme code="usBankAccount.first.name"/></label><br>
                                                    <input id="first-name" class="text form-control us-bank-account-fields" name="first-name" type="text"><br>
                                                    <label for="last-name"><spring:theme code="usBankAccount.last.name"/></label><br>
                                                    <input id="last-name" class="text form-control us-bank-account-fields" name="last-name" type="text"><br>
                                                </div>
                                                <div id="business-name-container">
                                                    <label for="business-name"><spring:theme code="usBankAccount.business.name"/></label><br>
                                                    <input id="business-name" class="text form-control" name="business-name" type="text"><br>
                                                </div>
                                                <div class="headline">
                                                    <h4><spring:theme code="usBankAccount.billing.address"/></h4>
                                                </div>
                                                <div>
                                                    <label for="billing-street-address"><spring:theme code="usBankAccount.street.address"/></label><br>
                                                    <input id="billing-street-address" class="text form-control" name="billing-street-address" type="text"><br>
                                                </div>
                                                <div>
                                                    <label for="billing-extended-address"><spring:theme code="usBankAccount.extended.address"/></label><br>
                                                    <input id="billing-extended-address" class="text form-control" name="billing-extended-address" type="text"><br>
                                                </div>
                                                <div>
                                                    <label for="billing-locality"><spring:theme code="usBankAccount.city"/></label><br>
                                                    <input id="billing-locality" class="text form-control" name="billing-locality" type="text"><br>
                                                </div>
                                                <div>
                                                    <label for="billing-region"><spring:theme code="usBankAccount.state"/></label><br>
                                                    <select id="billing-region" class="form-control" name="billing-region">
                                                        <c:forEach items="${regions}" var="region">
                                                            <option value="${region.isocodeShort}">
                                                                    ${region.name}
                                                            </option>

                                                        </c:forEach>
                                                    </select></br>
                                                </div>
                                                <div>
                                                    <label for="billing-postal-code"><spring:theme code="usBankAccount.postal.code"/></label><br>
                                                    <input id="billing-postal-code" class="text form-control" name="billing-postal-code" type="text"><br>
                                                </div>
                                            </div>

                                            <c:if test="${payPalCheckoutData.configurationData.storeInVault}">
                                                <div class="form-additionals" id="savePaymentInfoComponent">
                                                    <sec:authorize access="!hasAnyRole('ROLE_ANONYMOUS')">
                                                        <formElement:formCheckbox idKey="savePaymentInfo"
                                                                                  labelKey="checkout.multi.sop.savePaymentInfo"
                                                                                  path="savePaymentInfo" inputCSS="" labelCSS=""
                                                                                  mandatory="false"/>
                                                    </sec:authorize>
                                                </div>
                                                <script>
                                                  if (document.getElementById("savePaymentInfo")) {
                                                    if (paypalIntent.toLowerCase() === 'order') {
                                                      document.getElementById("savePaymentInfo").checked = false;
                                                      document.getElementById("savePaymentInfoComponent").style.display = 'none';
                                                    } else {
                                                      document.getElementById("savePaymentInfo").checked = true;
                                                    }
                                                  }
                                                </script>
                                            </c:if>

                                            <div id="us-bank-account-text-and-button-container">
                                                <div id="mandate-text">
                                                    <div id="for-saving-payment-method">
                                                        <spring:message code="usBankAccount.text.save"
                                                                        arguments="${[payPalCheckoutData.usBankAccountPaymentMethod.merchantName]}"
                                                                        htmlEscape="false"
                                                        />
                                                    </div>
                                                    <div id="for-not-saving-payment-method">
                                                        <spring:message code="usBankAccount.text.one.time"
                                                                        arguments="${[payPalCheckoutData.usBankAccountPaymentMethod.merchantName, cartData.totalPrice.formattedValue, currentDate]}"
                                                                        htmlEscape="false"
                                                        />
                                                    </div>
                                                </div>
                                                <input id="us-bank-account-button-continue" type="button" value="Next" onclick="" class="btn btn-primary btn-block checkout-next">
                                            </div>

                                            <div class="billingAddressData">

                                                <div class="headline clear">
                                                    <spring:theme
                                                            code="checkout.multi.paymentMethod.addPaymentDetails.billingAddress"/>
                                                </div>

                                                <c:if test="${cartData.deliveryItemsQuantity > 0}">
                                                    <div id="useDeliveryAddressData"
                                                         data-firstname="${deliveryAddress.firstName}"
                                                         data-lastname="${deliveryAddress.lastName}"
                                                         data-line1="${deliveryAddress.line1}"
                                                         data-line2="${deliveryAddress.line2}"
                                                         data-town="${deliveryAddress.town}"
                                                         data-postalcode="${deliveryAddress.postalCode}"
                                                         data-countryisocode="${deliveryAddress.country.isocode}"
                                                         data-regionisocode="${deliveryAddress.region.isocodeShort}"
                                                         data-address-id="${deliveryAddress.id}"></div>
                                                    <formElement:formCheckbox path="useDeliveryAddress"
                                                                              idKey="useDeliveryAddress"
                                                                              labelKey="checkout.multi.sop.useMyDeliveryAddress"
                                                                              tabindex="11"/>
                                                </c:if>

                                                <input type="hidden" name="paypal_email" id="paypal_email"/>
                                                <input type="hidden"
                                                       value="${silentOrderPageData.parameters['billTo_email']}"
                                                       class="text" name="billTo_email" id="billTo_email">
                                                <address:billAddressFormSelector
                                                        supportedCountries="${countries}" regions="${regions}"
                                                        tabindex="12"/>
                                            </div>

                                            <div class="form-additionals"></div>

                                            <p>
                                                <spring:theme
                                                        code="checkout.multi.paymentMethod.seeOrderSummaryForMoreInformation"/>
                                            </p>

                                            <button type="submit" id="submit_silentOrderPostForm"
                                                    class="btn btn-primary btn-block checkout-next">
                                                <spring:theme code="checkout.multi.paymentMethod.continue"
                                                              text="Next"/>
                                            </button>
                                            <div id="paypalButtonError"></div>
                                            <div id="google-pay-button" class="google-pay-button-container google_pay_container"></div>
                                            <style>
                                              .apple-pay-button {
                                                  display: inline-block;
                                                  -webkit-appearance: -apple-pay-button;
                                                  -apple-pay-button-type: ${applePayButtonConfig.type}; /* Use any supported button type. */
                                                  -apple-pay-button-style: ${applePayButtonConfig.color};
                                                  -apple-pay-button-border-radius: 0px;
                                              }
                                            </style>
                                            <div id="apple-pay-button" class="apple-pay-button apple-pay-button-container hide">
                                            </div>
                                            <div id="mark-paypal-button" class="paypal_button_container btn btn-block horizontal-btn"></div>

                                            <div id="lpm-buttons" class="paypal_button_container">
                                                <c:forEach items="${payPalCheckoutData.localPaymentMethod.localPaymentMethods}"
                                                           var="localPaymentMethod">
                                                    <div id="${localPaymentMethod.code}" class="btn-local-payment-methods btn btn-block">
                                                        <div>
                                                            <img class="payment-button" src="${localPaymentMethod.pathToImage}"
                                                                 alt="${localPaymentMethod.altText}">
                                                        </div>
                                                        <label>${localPaymentMethod.name}</label>
                                                    </div>
                                                </c:forEach>
                                            </div>
                                            <div id="src-button" class="src-button-container src_container">
                                                <img src="${srcImgUrl}" alt="Visa Checkout" class="v-button" role="button"/>
                                            </div>
                                        </form:form>
                                    </ycommerce:testId>

                                </div>

                                <div id="verifying-cvv" class="bt-display-none">
                                    <div class="headline mt-20px"><spring:theme
                                            code="checkout.multi.paymentMethod.cvv.verification.title"/></div>
                                    <div>
                                        <c:forEach items="${braintreePaymentInfos}" var="paymentInfo">
                                            <div id="paymentMethodVerification${paymentInfo.id}" class="bt-display-none payment-method-container">
                                                <div class="expire-status-choose-cc-content-box">
                                                    <fragments:expiredStatus expirationStatus="${paymentInfo.expirationStatus}"
                                                                             expireRemained="${paymentInfo.reminderMonthToExpire}"/>
                                                </div><br/>
                                                <spring:theme code="paymentMethod.type.CreditCard"/><br/>
                                                <c:if test="${not empty paymentInfo.cardholderName}">
                                                    ${fn:escapeXml(paymentInfo.cardholderName)}<br/>
                                                </c:if>
                                                    ${fn:escapeXml(paymentInfo.cardNumber)}<br/>
                                                    ${fn:escapeXml(paymentInfo.cardType)}<br/>
                                                <c:if test="${not empty paymentInfo.expiryMonth}">
                                                    <spring:theme
                                                            code="checkout.multi.paymentMethod.paymentDetails.expires"
                                                            arguments="${fn:escapeXml(paymentInfo.expiryMonth)},${fn:escapeXml(paymentInfo.expiryYear)}"/>
                                                    <br/>
                                                </c:if>
                                                <c:if test="${not empty paymentInfo.accountHolderName}">
                                                    <img src="${fn:escapeXml(paymentInfo.accountHolderName)}"
                                                         alt="Card Type"/>
                                                    <br/>
                                                </c:if>
                                                <strong>${fn:escapeXml(paymentInfo.billingAddress.firstName)}&nbsp; ${fn:escapeXml(paymentInfo.billingAddress.lastName)}</strong><br/>
                                                    ${fn:escapeXml(paymentInfo.billingAddress.line1)}&nbsp;
                                                <c:if test="${not empty paymentInfo.billingAddress.line2}">
                                                    ${fn:escapeXml(paymentInfo.billingAddress.line2)}
                                                </c:if><br/>
                                                    ${fn:escapeXml(paymentInfo.billingAddress.town)}&nbsp; ${fn:escapeXml(paymentInfo.billingAddress.region.isocodeShort)}<br/>
                                                    ${fn:escapeXml(paymentInfo.billingAddress.postalCode)}&nbsp; ${fn:escapeXml(paymentInfo.billingAddress.country.isocode)}<br/>
                                            </div>
                                        </c:forEach>
                                    </div>

                                    <label for="cvv" class="control-label "><spring:theme
                                            code="braintree.text.cc.cvv"/></label>
                                    <div id="verify-cvv" class="controls verify-cvv-input"></div>
                                    <div class="buttons-payment-method-container">
                                        <input id="verify-cvv-button" type="button" value="Next" onclick=""
                                               class="next-button-payment-method-container btn btn-primary btn-block">
                                        <input id="verify-cvv-cancel-button" type="button" value="Cancel"
                                               class="cancel-buttons-payment-method-container btn btn-block btn-default"
                                               onclick="disabledButtons(); window.location.href='${request.contextPath}/checkout/multi/payment-method/add';">
                                    </div>
                                </div>
                            </div>

                            <c:if test="${not empty braintreePaymentInfos}">
                                <div id="savedpayments">
                                    <div id="savedpaymentstitle">
                                        <div class="headline">
                                        <span class="headline-text"><spring:theme
                                                code="checkout.multi.paymentMethod.addPaymentDetails.useSavedPaymentMethod"/></span>
                                        </div>
                                    </div>
                                    <div id="savedpaymentsbody">
                                        <c:forEach items="${braintreePaymentInfos}" var="paymentInfo"
                                                   varStatus="status">
                                            <input type="text" value="${paymentInfo.subscriptionId}" class=" paymentType hide">
                                            <form id="savedPaymentInfoForm${paymentInfo.id}"
                                                  action="${request.contextPath}/checkout/multi/payment-method/braintree/choose-cc"
                                                  method="GET">
                                                <input type="hidden" name="selectedPaymentMethodId"
                                                       value="${paymentInfo.id}"/>
                                                <input type="hidden" name="selectedPaymentMethodNonce"
                                                       value="${paymentInfo.paymentMethodNonce}">
                                                <input type="hidden" name="selectedPaymentMethodCvvNonce"
                                                       value="${null}">
                                                <input type="hidden" name="is3dSecureFlow"
                                                       value="false">
                                                <c:choose>
                                                    <c:when
                                                            test="${paymentInfo.subscriptionId eq 'BrainTreePayPalExpress' or paymentInfo.subscriptionId eq 'PayPalAccount'}">
                                                        <input type="hidden" name="selectedPaymentMethod" value="PayPal">
                                                        <c:choose>
                                                            <c:when test="${paymentInfo.paypalFundingSource eq 'card'}">
                                                                <spring:theme code="paymentMethod.type.PayPalCard" />
                                                            </c:when>
                                                            <c:otherwise>
                                                                <spring:theme code="paymentMethod.type.PayPal" />
                                                            </c:otherwise>
                                                        </c:choose>
                                                        <br/>
                                                        ${fn:escapeXml(paymentInfo.payer)}<br/>
                                                        <img
                                                                src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-medium.png"
                                                                alt="PayPal icon"/>
                                                        <br/>
                                                    </c:when>
                                                    <c:when test="${paymentInfo.subscriptionId eq 'VenmoAccount'}">
                                                        <br><spring:theme code="paymentMethod.type.Venmo" /><br/>
                                                        <input type="hidden" name="selectedPaymentMethod" value="PayPal">
                                                        ${fn:escapeXml(paymentInfo.payer)}<br>
                                                        <img height="28" width="56"
                                                             src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/venmo_acceptance_mark.svg"
                                                             alt="Venmo icon"/>
                                                        <br/>
                                                    </c:when>
                                                    <c:when test="${paymentInfo.subscriptionId eq 'UsBankAccount'}">
                                                        <br><spring:theme code="paymentMethod.type.usBankAccount"/><br/>
                                                        <input type="hidden" name="selectedPaymentMethod" value="PayPal">
                                                        <spring:theme code="paymentMethod.usBankAccount.accountNumber"/>
                                                        ${fn:escapeXml(paymentInfo.last4)}<br>
                                                        <img height="28" width="42"
                                                             src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/us_bank_account_acceptance_mark.png"
                                                             alt="ACH icon"/>
                                                        <br/>
                                                    </c:when>
                                                    <c:when test="${paymentInfo.subscriptionId eq 'AndroidPayCard'}">
                                                        <input type="hidden" name="selectedPaymentMethod" value="AndroidPayCard">
                                                        <br><spring:theme code="paymentMethod.type.GooglePay"/>
                                                        <br>${fn:escapeXml(paymentInfo.payer)}
                                                        <br>${fn:escapeXml(paymentInfo.cardNumber)}
                                                        <br>${fn:escapeXml(paymentInfo.cardType)}
                                                        <br><spring:theme code="text.expires" text="Expires"/>
                                                        <c:if test="${not empty paymentInfo.expiryMonth}">
                                                        <span>
                                                        ${fn:escapeXml(paymentInfo.expiryMonth)} /
                                                        ${fn:escapeXml(paymentInfo.expiryYear)}
                                                        </span>
                                                        </c:if>
                                                        <br><img height="38" width="56"
                                                                 src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/googlePay_mark.png"
                                                                 alt="GooglePay icon"/> <br>
                                                    </c:when>
                                                    <c:when test="${paymentInfo.subscriptionId eq 'VisaCheckoutCard'}">
                                                        <input type="hidden" name="selectedPaymentMethod" value="VisaCheckoutCard">
                                                        <br><spring:theme code="paymentMethod.type.Src" />
                                                        <br>${fn:escapeXml(paymentInfo.payer)}
                                                        <br>${fn:escapeXml(paymentInfo.cardNumber)}
                                                        <br>${fn:escapeXml(paymentInfo.cardType)}
                                                        <c:if test="${not empty paymentInfo.expiryMonth}">
                                                            <br>
                                                            <spring:theme
                                                                    code="checkout.multi.paymentMethod.paymentDetails.expires"
                                                                    arguments="${fn:escapeXml(paymentInfo.expiryMonth)},${fn:escapeXml(paymentInfo.expiryYear)}"/>
                                                            <br/>
                                                        </c:if>
                                                        <c:if test="${not empty paymentInfo.accountHolderName}">
                                                            <img src="${fn:escapeXml(paymentInfo.accountHolderName)}"
                                                                 alt="Card Type"/>
                                                            <br/>
                                                        </c:if>
                                                    </c:when>
                                                    <c:otherwise>
                                                        <input type="hidden" name="selectedPaymentMethod" value="creditCardPaymentMethod"/>
                                                        <div class="expire-status-choose-cc-content-box">
                                                            <fragments:expiredStatus expirationStatus="${paymentInfo.expirationStatus}"
                                                                                     expireRemained="${paymentInfo.reminderMonthToExpire}"/>
                                                        </div><br/>
                                                        <spring:theme code="paymentMethod.type.CreditCard"/><br/>
                                                        <c:if test="${not empty paymentInfo.cardholderName}">
                                                            ${fn:escapeXml(paymentInfo.cardholderName)}<br/>
                                                        </c:if>
                                                        ${fn:escapeXml(paymentInfo.cardNumber)}<br/>
                                                        ${fn:escapeXml(paymentInfo.cardType)}<br/>
                                                        <c:if test="${not empty paymentInfo.expiryMonth}">
                                                            <spring:theme
                                                                    code="checkout.multi.paymentMethod.paymentDetails.expires"
                                                                    arguments="${fn:escapeXml(paymentInfo.expiryMonth)},${fn:escapeXml(paymentInfo.expiryYear)}"/>
                                                            <br/>
                                                        </c:if>
                                                        <c:if test="${not empty paymentInfo.accountHolderName}">
                                                            <img src="${fn:escapeXml(paymentInfo.accountHolderName)}"
                                                                 alt="Card Type"/>
                                                            <br/>
                                                        </c:if>
                                                    </c:otherwise>
                                                </c:choose>
                                                <strong>${fn:escapeXml(paymentInfo.billingAddress.firstName)}&nbsp; ${fn:escapeXml(paymentInfo.billingAddress.lastName)}</strong><br/>
                                                    ${fn:escapeXml(paymentInfo.billingAddress.line1)}&nbsp;
                                                <c:if test="${not empty paymentInfo.billingAddress.line2}">
                                                    ${fn:escapeXml(paymentInfo.billingAddress.line2)}
                                                </c:if><br/>
                                                    ${fn:escapeXml(paymentInfo.billingAddress.town)}&nbsp; ${fn:escapeXml(paymentInfo.billingAddress.region.isocodeShort)}<br/>
                                                    ${fn:escapeXml(paymentInfo.billingAddress.postalCode)}&nbsp; ${fn:escapeXml(paymentInfo.billingAddress.country.isocode)}<br/>
                                                <c:choose>
                                                    <c:when test="${paymentInfo.defaultPaymentInfo}">
                                                        <button type="submit" class="btn btn-primary btn-block default-payment-method"
                                                                id="useSelectedPaymentMethod${paymentInfo.id}"
                                                                tabindex="${fn:escapeXml((status.count * 2) - 1)}"><spring:theme
                                                                code="checkout.multi.paymentMethod.addPaymentDetails.useDefaultPaymentDetails"/></button>
                                                    </c:when>
                                                    <c:otherwise>
                                                        <button type="submit" class="btn btn-primary btn-block"
                                                                id="useSelectedPaymentMethod${paymentInfo.id}"
                                                                tabindex="${fn:escapeXml((status.count * 2) - 1)}"><spring:theme
                                                                code="checkout.multi.paymentMethod.addPaymentDetails.useThesePaymentDetails"/></button>
                                                    </c:otherwise>
                                                </c:choose>
                                            </form>
                                        </c:forEach>
                                    </div>
                                </div>
                            </c:if>
                        </c:otherwise>
                    </c:choose>
                </jsp:body>
            </multiCheckout:checkoutSteps>
        </div>

        <div class="col-sm-6 hidden-xs">
            <multiCheckout:checkoutOrderDetails cartData="${cartData}" showDeliveryAddress="true" showPaymentInfo="false"
                                                showTaxEstimate="false" showTax="true"/>
        </div>

        <div class="col-sm-12 col-lg-12">
            <cms:pageSlot position="SideContent" var="feature" element="div" class="checkout-help">
                <cms:component component="${feature}"/>
            </cms:pageSlot>
        </div>
    </div>

    <spring:eval expression="@configurationService.configuration.getProperty('braintree.user.action')" var="userAction"/>

    <util:importBtSDK
            sdkVersion="3.85.3"
            enablePayPal="${payPalCheckoutData.payPalPaymentMethod.payPalStandardEnabled}"
            enableHostedFields="${payPalCheckoutData.creditCardPaymentMethod.hostedFieldsEnable}"
            enableGooglePay="${payPalCheckoutData.googlePayPaymentMethod.googlePayEnabled}"
            enableVenmo="${payPalCheckoutData.venmoPaymentMethod.venmoEnabled}"
            enableLocalPayment="${payPalCheckoutData.localPaymentMethod.localPaymentMethodsEnabled}"
            enableUsBankAccount="${payPalCheckoutData.usBankAccountPaymentMethod.usBankAccountEnabled}"
            enableApplePay="${payPalCheckoutData.applePayPaymentMethod.applePayEnabled}"
            enableSecure3d="${payPalCheckoutData.creditCardPaymentMethod.secure3d}"
            enableSecure3dFallback="${payPalCheckoutData.creditCardPaymentMethod.secure3dFallback}"
            enableSrc="${payPalCheckoutData.srcPaymentMethod.srcEnabled}"
            enableDropIn="${payPalCheckoutData.dropIn.dropInEnabled}"/>

    <importCheckoutData:importMarkCheckoutData payPalCheckoutData="${payPalCheckoutData}"/>

    <script>
        var isCreditCardSelect = "${is_credit_card_select}";
        var isSingleUseSelect = "${is_single_use_select}";
        var payPalButtonConfig = ${payPalMarkButtonConfig};
        var googlePayButtonConfig = ${googlePayButtonConfig};
        var lpmids = ${lpmids};
        var countryIsocode = "${deliveryAddress.country.isocode}";
        var braintreeUserName= "${userData.firstName}";
        var braintreeUserSurname = "${userData.lastName}";
        var braintreeUserEmail = "${userData.email}";
        var applePayShape = "${applePayButtonConfig.shape}"
    </script>

</template:page>
