<%@ attribute name="sdkVersion" required="false" type="java.lang.String" %>
<%@ attribute name="enableGooglePay" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enableApplePay" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enablePayPal" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enableLocalPayment" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enableVenmo" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enableUsBankAccount" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enableSecure3d" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enableSecure3dFallback" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enableHostedFields" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enableSrc" required="false" type="java.lang.Boolean" %>
<%@ attribute name="enableDropIn" required="false" type="java.lang.Boolean" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/client.min.js"></script>
<script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/data-collector.min.js"></script>

<c:if test="${enablePayPal}">
    <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/paypal.min.js"></script>
    <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/paypal-checkout.min.js"></script>
</c:if>
<c:if test="${enableHostedFields}">
    <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/hosted-fields.min.js"></script>
</c:if>
<c:if test="${enableApplePay}">
    <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/apple-pay.min.js"></script>
</c:if>
<c:if test="${enableGooglePay}">
    <script type="text/javascript" src="https://pay.google.com/gp/p/js/pay.js"></script>
    <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/google-payment.min.js"></script>
</c:if>
<c:if test="${enableLocalPayment}">
    <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/local-payment.min.js"></script>
</c:if>
<c:if test="${enableVenmo}">
    <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/venmo.min.js"></script>
</c:if>
<c:if test="${enableUsBankAccount}">
    <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/us-bank-account.min.js"></script>
</c:if>
<c:choose>
    <c:when test="${not empty enableSecure3dOnMyAccount}">
        <c:if test="${(enableSecure3d || enableSecure3dFallback) && enableSecure3dOnMyAccount}">
            <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/three-d-secure.min.js"></script>
        </c:if>
    </c:when>
    <c:otherwise>
       <c:if test="${enableSecure3d || enableSecure3dFallback}">
           <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/three-d-secure.min.js"></script>
       </c:if>
    </c:otherwise>
</c:choose>
<c:if test="${enableSrc}">
    <script type="text/javascript" src="https://sandbox-assets.secure.checkout.visa.com/checkout-widget/resources/js/integration/v1/sdk.js"></script>
    <script type="text/javascript" src="https://js.braintreegateway.com/web/${sdkVersion}/js/visa-checkout.min.js"></script>
</c:if>
<c:if test="${enableDropIn}">
    <script type="text/javascript" src="https://js.braintreegateway.com/web/dropin/1.33.2/js/dropin.min.js"></script>
</c:if>
