<%@ attribute name="cartData" required="true" type="de.hybris.platform.commercefacades.order.data.CartData" %>
<%@ attribute name="paymentInfo" required="true" type="de.hybris.platform.commercefacades.order.data.CCPaymentInfoData" %>
<%@ attribute name="showPaymentInfo" required="false" type="java.lang.Boolean" %>
<%@ attribute name="brainTreePaymentInfo" required="false"
	type="com.braintree.hybris.data.BrainTreePaymentInfoData"%>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="format" tagdir="/WEB-INF/tags/shared/format" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<c:if test="${not empty paymentInfo && showPaymentInfo}">
    <ul class="checkout-order-summary-list">
        <li class="checkout-order-summary-list-heading">
            <div class="title"><spring:theme code="checkout.multi.payment" text="Payment:"></spring:theme></div>
            <div class="address">
				<c:choose>
					<c:when test="${brainTreePaymentInfo.paymentType eq 'BrainTreePayPalExpress' or brainTreePaymentInfo.paymentType eq 'PayPalAccount'}">
						<img
								src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-small.png"
								alt="PayPal icon" />
						<c:choose>
							<c:when test="${paymentInfo.paypalFundingSource eq 'card'}">
								<spring:theme code="paymentMethod.type.PayPalCard" />
							</c:when>
							<c:otherwise>
								<spring:theme code="paymentMethod.type.PayPal" />
							</c:otherwise>
						</c:choose>
						<div class="pp-account-email">${fn:escapeXml(brainTreePaymentInfo.email)}</div>
					</c:when>
                    <c:when test="${brainTreePaymentInfo.paymentType eq 'ApplePayCard'}">
                        <img height="28" width="56" src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/logo_apple.png"
                            alt="ApplePay icon" />
                        ${fn:escapeXml(brainTreePaymentInfo.email)}
                     </c:when>
					<c:when test="${brainTreePaymentInfo.paymentType eq 'VenmoAccount'}">
						<img height="28" width="56" src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/venmo_acceptance_mark.svg"
							 alt="Venmo icon" />
						<spring:theme code="paymentMethod.type.Venmo" />
						<div class="venmo-account-email">${fn:escapeXml(brainTreePaymentInfo.email)}</div>
					</c:when>
					<c:when test="${brainTreePaymentInfo.paymentType eq 'UsBankAccount'}">
						<img height="28" width="42"
							 src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/us_bank_account_acceptance_mark.png"
							 alt="ACH icon"/>
						<br><spring:theme code="paymentMethod.type.usBankAccount"/><br/>
						<spring:theme code="paymentMethod.usBankAccount.accountNumber"/>
						${fn:escapeXml(brainTreePaymentInfo.last4)}<br>
					</c:when>
					<c:when test="${brainTreePaymentInfo.paymentType eq 'AndroidPayCard'}">
						<spring:theme code="paymentMethod.type.GooglePay" />
						<div class="googlepay-account-email">${fn:escapeXml(brainTreePaymentInfo.email)}</div>
						${fn:escapeXml(brainTreePaymentInfo.cardType)},
						<img height="28" width="46" src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/googlePay_mark.png"
							 alt="GooglePay icon" />
						<br>
						${fn:escapeXml(brainTreePaymentInfo.cardNumber)}
						<c:if test="${not empty paymentInfo.expiryMonth}">
							, <spring:theme code="text.expires" text="Expires" />
							<span> ${fn:escapeXml(paymentInfo.expiryMonth)}/${fn:escapeXml(paymentInfo.expiryYear)}</span>
						</c:if>
						<br>
					</c:when>
					<c:when test="${brainTreePaymentInfo.paymentType eq 'VisaCheckoutCard'}">
						<spring:theme code="paymentMethod.type.Src" />
						<div class="src-account-email">${fn:escapeXml(brainTreePaymentInfo.email)}</div>
						${fn:escapeXml(brainTreePaymentInfo.cardType)},
						<c:if test="${not empty paymentInfo.accountHolderName}">
							<img src="${fn:escapeXml(paymentInfo.accountHolderName)}" alt="Card Type Icon"/>
						</c:if>
						<br>
						${fn:escapeXml(brainTreePaymentInfo.cardNumber)},
						<c:if test="${not empty paymentInfo.expiryMonth}">
							<spring:theme code="text.expires" text="Expires" />
							<span> ${fn:escapeXml(paymentInfo.expiryMonth)}/${fn:escapeXml(paymentInfo.expiryYear)}</span> <br>
						</c:if>
					</c:when>
					<c:otherwise>
							<spring:theme code="paymentMethod.type.CreditCard" /> <br>
							<c:if test="${not empty brainTreePaymentInfo.cardholderName}">
								${fn:escapeXml(brainTreePaymentInfo.cardholderName)} <br>
							</c:if>
							${fn:escapeXml(brainTreePaymentInfo.cardType)},
							<c:if test="${not empty brainTreePaymentInfo.imageSource}">
								<img src="${fn:escapeXml(brainTreePaymentInfo.imageSource)}" alt="Card Type Icon"/>
							</c:if>
							<br>
							${fn:escapeXml(brainTreePaymentInfo.cardNumber)},
							<c:if test="${not empty paymentInfo.expiryMonth}">
								<spring:theme code="text.expires" text="Expires" />
								<span> ${fn:escapeXml(paymentInfo.expiryMonth)}/${fn:escapeXml(paymentInfo.expiryYear)}</span> <br>
							</c:if>
					</c:otherwise>
				</c:choose>
				<c:if test="${not empty paymentInfo.billingAddress and paymentInfo.subscriptionId ne 'VenmoAccount'}">
					<c:if test="${not empty paymentInfo.billingAddress.line1}">${fn:escapeXml(paymentInfo.billingAddress.line1)},
					</c:if>
					<c:if test="${not empty paymentInfo.billingAddress.line2}">${fn:escapeXml(paymentInfo.billingAddress.line2)},
					</c:if>
					<c:if test="${not empty paymentInfo.billingAddress.town}">${fn:escapeXml(paymentInfo.billingAddress.town)},
					</c:if>
					<c:if test="${not empty paymentInfo.billingAddress.region.name}">${fn:escapeXml(paymentInfo.billingAddress.region.name)}&nbsp;
					</c:if>
					<c:if test="${not empty paymentInfo.billingAddress.postalCode}">${fn:escapeXml(paymentInfo.billingAddress.postalCode)},
					</c:if>
					<c:if test="${not empty paymentInfo.billingAddress.country.name}">${fn:escapeXml(paymentInfo.billingAddress.country.name)}
					</c:if>
				</c:if>
            </div>
        </li>
    </ul>
</c:if>

