function initializeSrc(isMiniCartCheckout) {

    braintree.visaCheckout.create({
      client: client
    }, function (visaCheckoutErr, visaCheckoutInstance) {

      if (visaCheckoutErr) {
        console.error('Error creating VisaCheckout:', visaCheckoutErr);
        return;
      }

      visaCheckoutInitialized(visaCheckoutInstance, isMiniCartCheckout);
    });



  function visaCheckoutInitialized(visaCheckoutInstance, isMiniCartCheckout) {
    var baseInitOptions = {
      paymentRequest: {
        currencyCode: currency,
        subtotal: amount
      }
    };

    var initOptions = visaCheckoutInstance.createInitOptions(baseInitOptions);
    V.init(initOptions);

    V.on('payment.success', function (payment) {
      visaCheckoutInstance.tokenize(payment, function (tokenizeErr, payload) {
        if (tokenizeErr) {
          console.error('Error during Visa Checkout tokenization', tokenizeErr);
        } else {
          processSrcResponse(payload, deviceData, isMiniCartCheckout);
        }
      });
    });
  }

}

function processSrcResponse(payload, deviceData, isMiniCartCheckout) {
  processExpressCheckoutForm(preparePayload(payload, deviceData), false, undefined, isMiniCartCheckout);
}

function preparePayload(response, deviceData) {
  var payloadCopy = {};
  payloadCopy.nonce = response.nonce;
  payloadCopy.details = {};
  payloadCopy.type = response.type;
  payloadCopy.details.email = response.userData.userEmail;

  payloadCopy.details.phone = response.billingAddress.phoneNumber;
  payloadCopy.details.billingAddress = {
    line1: response.billingAddress.streetAddress,
    city: response.billingAddress.locality,
    state: response.billingAddress.region?.toUpperCase(),
    postalCode: response.billingAddress.postalCode,
    countryCode: response.billingAddress.countryCode.toUpperCase(),
    phone: response.billingAddress.phoneNumber,
    recipientName: response.billingAddress.firstName + ' ' + response.billingAddress.lastName
  };

  payloadCopy.cardDetails = {
    expirationMonth: response.details.expirationMonth,
    expirationYear: response.details.expirationYear,
    bin: response.details.bin,
    cardType: response.details.cardType,
    lastFour: response.details.lastFour
  };

  payloadCopy.details.firstName = response.billingAddress.firstName;
  payloadCopy.details.lastName = response.billingAddress.lastName;

  if (typeof paymentMethodsPage == 'undefined' && typeof addPaymentMethodsPage == 'undefined') {
    payloadCopy.details.shippingAddress = {
      line1: response.shippingAddress.streetAddress,
      city: response.shippingAddress.locality,
      state: response.shippingAddress.region?.toUpperCase(),
      postalCode: response.shippingAddress.postalCode,
      countryCode: response.shippingAddress.countryCode.toUpperCase(),
      phone: response.shippingAddress.phoneNumber,
      recipientName: response.shippingAddress.firstName + ' ' + response.billingAddress.lastName
    };
  }

  return payloadCopy;
}
