<%@ page trimDirectiveWhitespaces="true" contentType="application/json" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="theme" tagdir="/WEB-INF/tags/shared/theme" %>
<%@ taglib prefix="format" tagdir="/WEB-INF/tags/shared/format" %>
<%@ taglib prefix="product" tagdir="/WEB-INF/tags/responsive/product" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags"%>
<%@ taglib prefix="cart" tagdir="/WEB-INF/tags/responsive/cart" %>
<%@ taglib prefix="importData" tagdir="/WEB-INF/tags/addons/braintreeaddon/responsive/util/pages" %>

<c:set var = "payPalExpressEnabled" scope = "session" value = "${payPalCheckoutData.payPalPaymentMethod.payPalExpressEnabled}"/>
<c:set var = "applePayEnabled" scope = "session" value = "${payPalCheckoutData.applePayPaymentMethod.applePayEnabled}"/>
<c:set var="applePayOnExpressCheckoutEnabled" scope="session" value="${payPalCheckoutData.applePayPaymentMethod.applePayOnExpressCheckoutEnabled}"/>
<c:set var = "googlePayEnabled" scope = "session" value = "${payPalCheckoutData.googlePayPaymentMethod.googlePayEnabled}"/>
<c:set var="googlePayOnExpressCheckoutEnabled" scope="session" value="${payPalCheckoutData.googlePayPaymentMethod.googlePayOnExpressCheckoutEnabled}"/>
<c:set var="dropInEnabled" scope="session" value="${payPalCheckoutData.dropIn.dropInEnabled}"/>

{"cartData": {
"total": "${cartData.totalPrice.value}",
"products": [
<c:forEach items="${cartData.entries}" var="cartEntry" varStatus="status">
	{
		"sku":		"${cartEntry.product.code}",
		"name": 	"<c:out value='${cartEntry.product.name}' />",
		"qty": 		"${cartEntry.quantity}",
		"price": 	"${cartEntry.basePrice.value}",
		"categories": [
		<c:forEach items="${cartEntry.product.categories}" var="category" varStatus="categoryStatus">
			"<c:out value='${category.name}' />"<c:if test="${not categoryStatus.last}">,</c:if>
		</c:forEach>
		]
	}<c:if test="${not status.last}">,</c:if>
</c:forEach>
]
},

"quickOrderErrorData": [
<c:forEach items="${quickOrderErrorData}" var="quickOrderEntry" varStatus="status">
	{
		"sku":		"${quickOrderEntry.productData.code}",
		"errorMsg": "<spring:theme code='${quickOrderEntry.errorMsg}' htmlEscape='true' />"
	}<c:if test="${not status.last}">,</c:if>
</c:forEach>
],

"cartAnalyticsData":{"cartCode" : "${cartCode}","productPostPrice":"${entry.basePrice.value}","productName":"<c:out value='${product.name}' />"}
,
"addToCartLayer":"<spring:escapeBody javaScriptEscape='true'>
	<jsp:include page='../../../messages/braintreeErrorMessages.jsp' />

	<spring:theme code="text.addToCart" var="addToCartText"/>
	<c:url value="/cart" var="cartUrl"/>
	<c:url value="/cart/checkout" var="checkoutUrl"/>

	<ycommerce:testId code="addToCartPopup">
		<div id="addToCartLayer" class="add-to-cart">
            <div class="cart_popup_error_msg">
                <c:choose>
	                <c:when test="${quickOrderErrorData ne null and not empty quickOrderErrorData}">
	                	<spring:theme code="${quickOrderErrorMsg}" arguments="${fn:length(quickOrderErrorData)}" htmlEscape="true" />
                    </c:when>
                    <c:when test="${multidErrorMsgs ne null and not empty multidErrorMsgs}">
                        <c:forEach items="${multidErrorMsgs}" var="multidErrorMsg">
                            <spring:theme code="${multidErrorMsg}" />
                        </br>
                        </c:forEach>
                    </c:when>
                    <c:otherwise>
                        <spring:theme code="${errorMsg}" />
                    </c:otherwise>
                </c:choose>
            </div>

            <c:choose>
                <c:when test="${modifications ne null}">

                    <c:forEach items="${modifications}" var="modification">
                        <c:set var="product" value="${modification.entry.product}" />
                        <c:set var="entry" value="${modification.entry}" />
                        <c:set var="quantity" value="${modification.quantityAdded}" />
                        <cart:popupCartItems entry="${entry}" product="${product}" quantity="${quantity}"/>
                    </c:forEach>
                </c:when>
                <c:otherwise>

                    <cart:popupCartItems entry="${entry}" product="${product}" quantity="${quantity}"/>
                </c:otherwise>
            </c:choose>

            <importData:importMiniCartCheckoutData payPalCheckoutData="${payPalCheckoutData}" addToCartPopup="addToCartPopup"/>
			<script>
                var payPalButtonConfig = ${payPalButtonConfig};
				var googlePayButtonConfig = ${googlePayButtonConfig};
    			var payPalShouldBeSaved = "${payPalShouldBeSaved}";
				var googlePayMiniCartDropInConfig = ${googlePayMiniCartDropInConfig};
				var payPalMiniCartDropInConfig = ${payPalMiniCartDropInConfig};
				var applePayMiniCartDropInConfig = ${applePayMiniCartDropInConfig};
	        </script>

			<div id="wrapper">
				<div id="row">
					<c:choose>
					<c:when test="${dropInEnabled}">
						<div id="dropin-container-mini-cart" class="dropin-container-express-checkout hidden"></div>
					</c:when>
					<c:otherwise>
						<div id="paypal_express_error"></div>
							<div id="paypayShortcut" class="bt_center">
								<c:if test="${applePayEnabled and applePayOnExpressCheckoutEnabled}">
									<style>
										.apple-pay-button {
										display: inline-block;
										-webkit-appearance: -apple-pay-button;
										-apple-pay-button-type: ${applePayButtonConfig.type};
										-apple-pay-button-style: ${applePayButtonConfig.color};
										-apple-pay-button-border-radius: 0px;
									}
									</style>

									<div id="apple-pay-button" class="apple-pay-button apple-pay-button-container hide"></div>

								</c:if>
								<c:if test="${payPalExpressEnabled}">
									<div id="paypal-button" class="paypal-button-in-popup paypal_button_container"></div>
								</c:if>
								<c:if test="${googlePayEnabled and googlePayOnExpressCheckoutEnabled}">
									<div id="google-pay-button" class="google_pay_container"></div>
								</c:if>
							</div>
					</c:otherwise>
					</c:choose>
					<div id="orSeparator" class="bt_center"><spring:theme code="braintree.cart.or"/></div>
				</div>
			</div>
      <ycommerce:testId code="checkoutLinkInPopup">
          <a href="${cartUrl}" class="btn btn-primary btn-block add-to-cart-button">
              <spring:theme code="checkout.checkout" />
          </a>
      </ycommerce:testId>
      <a href="" class="btn btn-default btn-block js-mini-cart-close-button">
          <spring:theme code="cart.page.continue"/>
      </a>

      <script>
				configurePaypalShortcut(CONST.PAYPAL_BUTTON_CONTAINER);
				if(applePayEnabled){
          changeApplePayButtonShape("${applePayButtonConfig.shape}");
        }
			</script>
		</div>
	</ycommerce:testId>
</spring:escapeBody>"
}
