package com.braintree.converters.populators;

import com.braintree.hybris.data.ws.BrainTreePaymentTransactionEntryWsDTO;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;


public class BrainTreePaymentTransactionEntryPopulator implements
    Populator<PaymentTransactionEntryModel, BrainTreePaymentTransactionEntryWsDTO> {


    @Override
    public void populate(PaymentTransactionEntryModel paymentTransaction,
        BrainTreePaymentTransactionEntryWsDTO transactionEntryWsDTO) throws ConversionException {

        transactionEntryWsDTO.setAmount(String.valueOf(paymentTransaction.getAmount().doubleValue()));
        transactionEntryWsDTO.setCurrencyIsocode(paymentTransaction.getCurrency().getIsocode());
        transactionEntryWsDTO.setRequestId(paymentTransaction.getRequestId());
        transactionEntryWsDTO.setTime(paymentTransaction.getTime().toString());
        transactionEntryWsDTO.setTransactionStatus(paymentTransaction.getTransactionStatus());
        transactionEntryWsDTO.setTransactionStatusDetails(paymentTransaction.getTransactionStatusDetails());
        transactionEntryWsDTO.setType(paymentTransaction.getType().getCode());
    }


}
