package com.braintree.validators.impl;

import com.braintree.hybris.data.ws.ApplePayPaymentRequestWsDTO;
import com.braintree.validators.BrainTreeValidator;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

import static com.braintree.constants.BraintreeoccaddonWebConstants.FIELD_REQUIRED_MESSAGE_ID;

public class BraintreeApplePayPaymentRequestValidator implements BrainTreeValidator {

    private Validator paymentAddressValidator;

    @Override
    public boolean supports(Class<?> clazz) {
        return ApplePayPaymentRequestWsDTO.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, Errors errors) {
        final ApplePayPaymentRequestWsDTO paymentResponse = (ApplePayPaymentRequestWsDTO) target;

        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "nonce", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "type", FIELD_REQUIRED_MESSAGE_ID);

        Assert.notNull(paymentResponse.getBillingContact(), "BillingAddress object must not be null");
        validate(paymentResponse.getBillingContact(), "billingAddress", getPaymentAddressValidator());

    }

    public Validator getPaymentAddressValidator() {
        return paymentAddressValidator;
    }

    public void setPaymentAddressValidator(Validator paymentAddressValidator) {
        this.paymentAddressValidator = paymentAddressValidator;
    }
}
