package com.braintree.controllers;

import com.braintree.facade.impl.DefaultBrainTreePaymentFacade;
import com.braintree.hybris.data.ws.ExpiredStatusMessageWsDTO;
import de.hybris.platform.webservicescommons.cache.CacheControl;
import de.hybris.platform.webservicescommons.cache.CacheControlDirective;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdAndUserIdParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@RequestMapping(value = "/{baseSiteId}/braintreeLogin")
@CacheControl(directive = CacheControlDirective.NO_CACHE)
@Api(tags = "PayPal Connect")
public class BraintreeLoginController extends BraintreeBaseController {

    @Resource(name = "brainTreePaymentFacadeImpl")
    private DefaultBrainTreePaymentFacade brainTreePaymentFacade;

    @Secured({"ROLE_CLIENT", "ROLE_CUSTOMERGROUP", "ROLE_GUEST", "ROLE_CUSTOMERMANAGERGROUP", "ROLE_TRUSTED_CLIENT",
            "ROLE_ANONYMOUS"})
    @GetMapping(value = "/getExpireCardsStatus")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(nickname = "getDataForExpireCardMessage", value = "get data for expire card message")
    @ApiBaseSiteIdAndUserIdParam
    public ExpiredStatusMessageWsDTO getExpireCardsStatus() {
        final ExpiredStatusMessageWsDTO expiredStatusMessageWsDTO = new ExpiredStatusMessageWsDTO();
        expiredStatusMessageWsDTO.setExpiredStatus(brainTreePaymentFacade.getExpirationStatusForCustomer());
        return expiredStatusMessageWsDTO;
    }
}
