/**
 *
 */
package com.braintree.converters.populators;

import static org.mockito.Mockito.when;

import com.braintree.hybris.data.ws.BrainTreePaymentTransactionEntryWsDTO;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

@UnitTest
public class BrainTreePaymentTransactionEntryPopulatorTest {

    private static final BigDecimal AMOUNT = BigDecimal.TEN;
    private static final String CURRENCY_ISO_CODE = "currencyIsoCode";
    private static final String REQUEST_ID = "requestId";
    private static final Date TRANSACTION_DATE = new Date();
    private static final String STATUS = "status";
    private static final String STATUS_DETAILS = "statusDetails";
    private static final PaymentTransactionType PAYMENT_TRANSACTION_TYPE = PaymentTransactionType.AUTHORIZATION;

    private BrainTreePaymentTransactionEntryPopulator unit;

    private PaymentTransactionEntryModel paymentTransaction;


    @Before
    public void setUp() {
        unit = new BrainTreePaymentTransactionEntryPopulator();
        paymentTransaction = Mockito.mock(PaymentTransactionEntryModel.class);
        final CurrencyModel currencyModel = Mockito.mock(CurrencyModel.class);
        when(currencyModel.getIsocode()).thenReturn(CURRENCY_ISO_CODE);
        when(paymentTransaction.getAmount()).thenReturn(AMOUNT);
        when(paymentTransaction.getCurrency()).thenReturn(currencyModel);
        when(paymentTransaction.getRequestId()).thenReturn(REQUEST_ID);
        when(paymentTransaction.getTime()).thenReturn(TRANSACTION_DATE);
        when(paymentTransaction.getTransactionStatus()).thenReturn(STATUS);
        when(paymentTransaction.getTransactionStatusDetails()).thenReturn(STATUS_DETAILS);
        when(paymentTransaction.getType()).thenReturn(PAYMENT_TRANSACTION_TYPE);
    }

    @Test
    public void populateShouldSetRequiredFields() {
        final BrainTreePaymentTransactionEntryWsDTO result = new BrainTreePaymentTransactionEntryWsDTO();
        unit.populate(paymentTransaction, result);
        Assert.assertEquals(String.valueOf(AMOUNT.doubleValue()), result.getAmount());
        Assert.assertEquals(CURRENCY_ISO_CODE, result.getCurrencyIsocode());
        Assert.assertEquals(REQUEST_ID, result.getRequestId());
        Assert.assertEquals(TRANSACTION_DATE.toString(), result.getTime());
        Assert.assertEquals(STATUS, result.getTransactionStatus());
        Assert.assertEquals(STATUS_DETAILS, result.getTransactionStatusDetails());
        Assert.assertEquals(PAYMENT_TRANSACTION_TYPE.getCode(), result.getType());
    }
}
