/**
 *
 */
package com.braintree.validators.impl;

import com.braintree.hybris.data.ws.BraintreeTokenizedCreditCardWsDTO;
import com.braintree.validators.BrainTreeValidator;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

import static com.braintree.constants.Braintreeb2boccaddonWebConstants.FIELD_REQUIRED_MESSAGE_ID;

public class BraintreeTokenizedCreditCardDataValidator implements BrainTreeValidator {

    @Override
    public boolean supports(Class aClass) {
        return BraintreeTokenizedCreditCardWsDTO.class.isAssignableFrom(aClass);
    }

    @Override
    public void validate(Object target, Errors errors) {

        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "nonce", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "details.cardType", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "description", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "type", FIELD_REQUIRED_MESSAGE_ID);

    }
}
