/**
 *
 */
package com.braintree.validators.impl;

import static com.braintree.constants.Braintreeb2boccaddonWebConstants.FIELD_REQUIRED_MESSAGE_ID;

import com.braintree.hybris.data.ws.SrcPaymentRequestWsDTO;
import com.braintree.validators.BrainTreeValidator;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class BraintreeSrcPaymentRequestValidator implements BrainTreeValidator {

    private Validator paymentAddressValidator;

    @Override
    public boolean supports(Class<?> clazz) {
        return SrcPaymentRequestWsDTO.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, Errors errors) {
        final SrcPaymentRequestWsDTO paymentResponse = (SrcPaymentRequestWsDTO) target;

        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "nonce", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "type", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "userEmail", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmpty(errors, "details", FIELD_REQUIRED_MESSAGE_ID);

        Assert.notNull(paymentResponse.getBillingAddress(), "BillingAddress object must not be null");
        validate(paymentResponse.getBillingAddress(), "billingAddress", getPaymentAddressValidator());
    }

    public Validator getPaymentAddressValidator() {
        return paymentAddressValidator;
    }

    public void setPaymentAddressValidator(Validator paymentAddressValidator) {
        this.paymentAddressValidator = paymentAddressValidator;
    }

}
