function createApplePay(options, buttonSelector, processResponseCallback) {
    braintree.applePay.create({
        client: client
    }, function (applePayErr, applePayInstance) {
        if (applePayErr) {
            console.error('Error creating applePayInstance:', applePayErr);
            return;
        }
        var createApplePaySession = function () {
            var paymentRequest;
            if (typeof paymentMethodsPage != 'undefined') {
                paymentRequest = applePayInstance.createPaymentRequest({
                    total: {
                        label: options.flow,
                        amount: amount
                    },
                    requiredBillingContactFields: ['postalAddress', 'name'],
                    requiredShippingContactFields: ['email']
                });
            } else {
                paymentRequest = applePayInstance.createPaymentRequest({
                    requiredBillingContactFields: ['postalAddress', 'name'],
                    requiredShippingContactFields: ['postalAddress', 'name', 'phone', 'email'],
                    total: {
                        label: options.flow,
                        amount: amount
                    }
                });
            }

            var session = new ApplePaySession(1, paymentRequest);

            session.onvalidatemerchant = function (event) {
                applePayInstance.performValidation({
                    validationURL: event.validationURL,
                    displayName: "Electronics"
                }, function (error, merchantSession) {
                    if (error) {
                        // Handle errors
                        console.error(error);
                        session.abort();
                        return;
                    }
                    session.completeMerchantValidation(merchantSession);
                });
            };
            session.onpaymentauthorized = function (event) {

                applePayInstance.tokenize({
                    token: event.payment.token
                }, function (error, payload) {
                    if (error) {
                        // Handle errors
                        console.error(error);
                        session.completePayment(ApplePaySession.STATUS_FAILURE);
                        return;
                    }

                    var shippingContact = event.payment.shippingContact;
                    var billingContact = event.payment.billingContact;

                    session.completePayment(ApplePaySession.STATUS_SUCCESS);

                    var payloadCopy = {};
                    payloadCopy.nonce = payload.nonce;
                    payloadCopy.details = {};
                    payloadCopy.cardDetails = {};
                    payloadCopy.type = payload.type;
                    payloadCopy.details.email = shippingContact.emailAddress;
                    payloadCopy.details.cardType = payload.details.cardType;
                    payloadCopy.cardDetails.cardType = payload.details.cardType;

                    payloadCopy.details.billingAddress = {
                        line1: billingContact.addressLines[0],
                        line2: billingContact.addressLines[1],
                        city: billingContact.locality,
                        state: billingContact.administrativeArea.toUpperCase(),
                        postalCode: billingContact.postalCode,
                        countryCode: billingContact.countryCode.toUpperCase(),
                        recipientName: billingContact.givenName + " " + shippingContact.familyName
                    };

                    if (typeof paymentMethodsPage == 'undefined') {
                        payloadCopy.details.firstName = shippingContact.givenName;
                        payloadCopy.details.lastName = shippingContact.familyName;
                        payloadCopy.details.phone = shippingContact.phoneNumber;

                        payloadCopy.details.shippingAddress = {
                            line1: shippingContact.addressLines[0],
                            line2: shippingContact.addressLines[1],
                            city: shippingContact.locality,
                            state: shippingContact.administrativeArea.toUpperCase(),
                            postalCode: shippingContact.postalCode,
                            countryCode: shippingContact.countryCode.toUpperCase(),
                            recipientName: shippingContact.givenName + " " + billingContact.familyName
                        };
                    }

                    processResponseCallback(payloadCopy);

                });
            };
            session.begin();
        };

        var promise = ApplePaySession.canMakePaymentsWithActiveCard(applePayInstance.merchantIdentifier);
        promise.then(function (canMakePaymentsWithActiveCard) {
            if (!canMakePaymentsWithActiveCard) {
                disableApplePay();
                createApplePaySession = null;
                return;
            }
            enableApplePay();
        });

        $(buttonSelector).unbind(EVENTS.CLICK);
        $(buttonSelector).click(function () {
            if (createApplePaySession != null) {
                createApplePaySession();
            }
        });
    });
}

function processApplePayResponseExpressCheckout(response, isMiniCartCheckout) {
    processExpressCheckoutForm(response, false, undefined, isMiniCartCheckout);
}

function showApplePay() {
    $(CONST.APPLE_PAY_BUTTON_CONTAINER).removeClass(CONST.HIDE);
}

function disableApplePay() {
    showApplePay();
    $(CONST.APPLE_PAY_BUTTON_SELECTOR).addClass("disabled-button");
    $(CONST.APPLE_PAY_BUTTON_SELECTOR).unbind('click');
}

function enableApplePay() {
    showApplePay();
    $(CONST.APPLE_PAY_BUTTON_SELECTOR).removeClass("disabled-button");
}

function removeApplePay() {
    $(CONST.APPLE_PAY_BUTTON_CONTAINER).remove();
    $(CONST.APPLEPAY_SELECTOR).remove();
}

function isAvailableApplePay() {
    return typeof window.ApplePaySession != "undefined" && ApplePaySession.canMakePayments();
}
