package com.braintree.controllers.handler;

import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.model.PayPalConnectButtonComponentB2BModel;
import de.hybris.platform.acceleratorstorefrontcommons.interceptors.BeforeViewHandler;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.ModelAndView;

public class PayPalConnectBeforeViewHandler implements BeforeViewHandler {

    private static final String B2B_ACCELERATOR_ADDON_VIEW_NAME = "addon:/b2bacceleratoraddon/pages/secureportal/login";
    private static final String CONNECT_WITH_PAYPAL_2205_VIEW_NAME = "addon:/braintreeb2baddon/pages/login/connectWithPayPalLogin";
    private static final String PAYAPAL_CONNECT_BUTTON_COMPONENT_B2B = "PayPalConnectButtonComponentB2B";
    private static final String PAYPAL_CONNECT_COMPONENT = "payPalConnectComponent";
    private static final String CONTAINER_ID = "containerID";
    private static final String THEME = "theme";
    private static final String BUTTON_TYPE = "buttonType";
    private static final String BUTTON_SHAPE = "buttonShape";
    private static final String BUTTON_SIZE = "buttonSize";
    private static final String FULL_PAGE = "fullPage";
    private static final String PAYPAL_CONNECT_SCRIPT = "payPalConnectScript";
    private static final String PAYPAL_CONNECT_SCOPES = "payPalConnectScopes";
    private static final String PAYPAL_CONNECT_RESPONSE_TYPE = "payPalConnectResponseType";
    private static final String PAYPAL_CONNECT_RETURN_URL = "payPalConnectReturnUrl";
    private static final String PAYPAL_ENV_CONFIGURATION = "environmentType";
    private static final String CLIENT_ID = "clientID";
    private static final String IS_PAYPAL_CONNECT_ENABLED = "isPayPalConnectEnabled";

    @Resource(name = "cmsComponentService")
    private CMSComponentService cmsComponentService;

    @Resource(name = "brainTreeConfigService")
    private BrainTreeConfigService brainTreeConfigService;

    @Override
    public void beforeView(HttpServletRequest request, HttpServletResponse response, ModelAndView modelAndView) throws Exception {
        if (modelAndView.getViewName().contentEquals(B2B_ACCELERATOR_ADDON_VIEW_NAME)) {
            modelAndView.setViewName(CONNECT_WITH_PAYPAL_2205_VIEW_NAME);
            addPayPalConnectComponent(modelAndView.getModelMap());
        }
    }

    private void addPayPalConnectComponent(ModelMap model) throws CMSItemNotFoundException {
        final PayPalConnectButtonComponentB2BModel payPalConnectModel;
        payPalConnectModel = cmsComponentService.getSimpleCMSComponent(PAYAPAL_CONNECT_BUTTON_COMPONENT_B2B);
        model.addAttribute(PAYPAL_CONNECT_COMPONENT, payPalConnectModel);
        model.addAttribute(CONTAINER_ID, payPalConnectModel.getButtonDiv());
        model.addAttribute(THEME, payPalConnectModel.getButtonTheme().toString().toLowerCase());
        model.addAttribute(BUTTON_TYPE, payPalConnectModel.getButtonType());
        model.addAttribute(BUTTON_SHAPE, payPalConnectModel.getButtonShape().toString().toLowerCase());
        model.addAttribute(BUTTON_SIZE, payPalConnectModel.getButtonSize().toString().toLowerCase());
        model.addAttribute(FULL_PAGE, payPalConnectModel.getFullPage());
        model.addAttribute(PAYPAL_CONNECT_SCRIPT, brainTreeConfigService.getPayPalConnectScript());
        model.addAttribute(PAYPAL_CONNECT_SCOPES, brainTreeConfigService.getPayPalConnectScopes());
        model.addAttribute(PAYPAL_CONNECT_RESPONSE_TYPE, brainTreeConfigService.getPayPalConnectResponseType());
        model.addAttribute(PAYPAL_CONNECT_RETURN_URL, brainTreeConfigService.getPayPalConnectReturnUrl());
        model.addAttribute(PAYPAL_ENV_CONFIGURATION, brainTreeConfigService.getEnvironmentType());
        model.addAttribute(CLIENT_ID, brainTreeConfigService.getClientID());
        model.addAttribute(IS_PAYPAL_CONNECT_ENABLED, payPalConnectModel.getEnabled());
    }
}
