package com.braintree.controllers.cms;

import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.model.PayPalConnectButtonComponentB2BModel;
import de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController;
import de.hybris.platform.commerceservices.request.mapping.annotation.RequestMappingOverride;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Controller("PayPalConnectButtonComponentB2BController")
@Scope("tenant")
@RequestMapping("/view/" + PayPalConnectButtonComponentB2BModel._TYPECODE + "Controller")
public class PayPalConnectButtonComponentB2BController  extends
        AbstractCMSAddOnComponentController<PayPalConnectButtonComponentB2BModel> {

    private static final String CONNECT_WITH_PAYPAL_COMPONENT = "PayPalConnectButtonComponentB2B";
    private static final String CONTAINER_ID = "containerID";
    private static final String THEME = "theme";
    private static final String BUTTON_TYPE = "buttonType";
    private static final String BUTTON_SHAPE = "buttonShape";
    private static final String BUTTON_SIZE = "buttonSize";
    private static final String FULL_PAGE = "fullPage";
    private static final String PAYPAL_CONNECT_SCRIPT = "payPalConnectScript";
    private static final String PAYPAL_CONNECT_SCOPES = "payPalConnectScopes";
    private static final String PAYPAL_CONNECT_RESPONSE_TYPE = "payPalConnectResponseType";
    private static final String PAYPAL_CONNECT_RETURN_URL = "payPalConnectReturnUrl";
    private static final String PAYPAL_ENV_CONFIGURATION = "environmentType";
    private static final String CLIENT_ID = "clientID";
    private static final String IS_PAYPAL_CONNECT_ENABLED = "isPayPalConnectEnabled";

    @Resource(name = "brainTreeConfigService")
    private BrainTreeConfigService brainTreeConfigService;

    @Override
    protected void fillModel(HttpServletRequest request, Model model, PayPalConnectButtonComponentB2BModel component) {
        model.addAttribute(CONTAINER_ID, component.getButtonDiv());
        model.addAttribute(THEME, component.getButtonTheme().toString().toLowerCase());
        model.addAttribute(BUTTON_TYPE, component.getButtonType());
        model.addAttribute(BUTTON_SHAPE, component.getButtonShape().toString().toLowerCase());
        model.addAttribute(BUTTON_SIZE, component.getButtonSize().toString().toLowerCase());
        model.addAttribute(FULL_PAGE, component.getFullPage());
        model.addAttribute(PAYPAL_CONNECT_SCRIPT, brainTreeConfigService.getPayPalConnectScript());
        model.addAttribute(PAYPAL_CONNECT_SCOPES, brainTreeConfigService.getPayPalConnectScopes());
        model.addAttribute(PAYPAL_CONNECT_RESPONSE_TYPE, brainTreeConfigService.getPayPalConnectResponseType());
        if (component.getUid().equals(CONNECT_WITH_PAYPAL_COMPONENT)) {
            model.addAttribute(PAYPAL_CONNECT_RETURN_URL, brainTreeConfigService.getPayPalConnectReturnUrl());
        } else {
            model.addAttribute(PAYPAL_CONNECT_RETURN_URL, brainTreeConfigService.getPayPalConnectCheckoutReturnUrl());
        }
        model.addAttribute(PAYPAL_ENV_CONFIGURATION, brainTreeConfigService.getEnvironmentType());
        model.addAttribute(CLIENT_ID, brainTreeConfigService.getClientID());
        model.addAttribute(IS_PAYPAL_CONNECT_ENABLED, component.getEnabled());
    }

    @Override
    @RequestMappingOverride
    @RequestMapping
    public String handleGet(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        return super.handleGet(request, response, model);
    }
}