/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.braintree.controllers;

import com.braintree.constants.Braintreeb2baddonConstants;

import static de.hybris.platform.acceleratorstorefrontcommons.controllers.AbstractController.ROOT;
import static de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractPageController.REDIRECT_TO_MULTISTEP_CHECKOUT;
import static de.hybris.platform.b2bacceleratoraddon.constants.B2bacceleratoraddonWebConstants.REDIRECT_PREFIX;

/**
 *
 */
public interface Braintreeb2baddonControllerConstants {

    final String ADDON_PREFIX = "addon:/braintreeb2baddon/";
    final String CLIENT_TOKEN = "client_token";
    final String PAY_PAL_CHECKOUT_DATA = "payPalCheckoutData";
    final String IS_ADDRESS_OPEN = "is_credit_card_select";
    final String PAY_PAL_CONFIGURATION_DATA = "payPalConfigurationData";
    String BRAINTREE_MY_ACCOUNT_TEXT_DROP_IN_LIMITED_DELETE_PAYMENT_METHODS = "braintree.myaccount.text.dropin.limited.delete.payment.methods";

    //localized error messages
    public static final String GENERAL_HEAD_ERROR = "braintree.checkout.general.error";
    public static final String GENERAL_HEAD_ERROR_MESSAGE = "braintree.checkout.general.error.message";
    String BRAINTREE_CVV_VERIFICATION_ERROR = "checkout.multi.paymentMethod.cvv.verification.general.error";

    public static final String PAY_PAL_GUEST_REGISTER_ERROR = "braintree.checkout.guest.error";
    public static final String PAY_PAL_ADDRESS_ERROR = "braintree.paypal.shipping.error";
    public static final String PAY_PAL_HAED_ERROR = "braintree.paypal.head.error";

    interface Views {

        interface Pages {

            interface MultiStepCheckout {

                String SilentOrderPostPage = ADDON_PREFIX + "pages/checkout/multi/silentOrderPostPage";
                String CheckoutOrderPageErrorPage = ADDON_PREFIX + "pages/checkout/multi/checkoutErrorPage";
                String CheckoutSummaryPage = ADDON_PREFIX + "pages/checkout/multi/checkoutSummaryPage";
                String FallbackPage = ADDON_PREFIX + "pages/checkout/multi/fallbackPage";
            }

            interface Checkout {

                String CheckoutConfirmationPage = ADDON_PREFIX + "pages/checkout/checkoutConfirmationPage";
                String ReplenishmentCheckoutConfirmationPage =
                    ADDON_PREFIX + "pages/checkout/replenishmentCheckoutConfirmationPage";
                String CheckoutLoginPage = "pages/checkout/checkoutLoginPage";
            }

            interface Account {

                String AccountLayoutPage = ADDON_PREFIX + "pages/account/accountLayoutPage";
                String AccountLoginPage = "pages/account/accountLoginPage";
            }
        }

        interface Fragments {

            interface Cart {

                String CartPopup = ADDON_PREFIX + "fragments/cart/cartPopup";
                String AddToCartPopup = ADDON_PREFIX + "fragments/cart/addToCartPopup";
            }
        }
    }

    String REGISTER_REQUEST_NOR_APPROVED = "braintree.paypal.connect.registration.request.notApproved";
    String REGISTER_REQUEST_CREATED = "braintree.paypal.connect.registration.request.created";
    String BRAINTREE_PAYPAL_CONNECT_REGISTRATION_MESSAGE_SET_UP_PASSWORD_FOR_NEW_USER = "braintree.paypal.connect.registration.message.set.up.password.for.new.user";
    String BRAINTREE_PAYPAL_CONNECT_LOGIN_LINKED_ACCOUNTS = "braintree.paypal.connect.login.linked.accounts";
    String PAYPAL_CONNECT_GLOBAL_ERROR = "braintree.paypal.connect.registration.global.error";
    String DISABLE_LOGIN_VIA_PAYPAL_TO_THE_EXISTING_USER_MESSAGE = "disable.login.via.paypal.to.the.existing.user.message";
    String SCP_LINK_CREATE_ACCOUNT = "text.secureportal.link.createAccount";
    String IS_USER_LOGGING_IN_FROM_LOGIN_PAGE = "IsUserLoggingInFromLoginPage";
    String ADD_ON_PREFIX = "addon:";
    String LOGIN_LABEL = "login";
    String CHECKOUT_LOGIN_LABEL = "checkout-login";
    String ACCESS_TOKEN = "accessToken";
    String BREADCRUBMS = "breadcrumbs";
    String LOGIN_PAGE_REDIRECT = REDIRECT_PREFIX + "/login";
    String CHECKOUT_LOGIN_PAGE_REDIRECT = REDIRECT_PREFIX + "/login/checkout";
    String REDIRECT_TO_CHECKOUT_PAGE = "/paypal/connect/noauthentication/register/checkout";
    String BRAINTREE_CONNECT_WITH_PAYPAL_ADDITIONAL_DATA = ADD_ON_PREFIX + "/" + Braintreeb2baddonConstants.EXTENSIONNAME + "/pages/login/additionalData";
    String REDIRECT_TO_NOAUTHENTICATION_REGISTER = "redirect:/paypal/connect/noauthentication/register";
    String REDIRECT_TO_NOAUTHENTICATION_REGISTER_CHECKOUT = "redirect:/paypal/connect/noauthentication/register/checkout";
    String REDIRECT_TO_MULTISTEP_CHECKOUT_FIRST_STEP = REDIRECT_TO_MULTISTEP_CHECKOUT + "/payment-type/choose";
    String HOME_REDIRECT = REDIRECT_PREFIX + ROOT;
    String SAVE_PAYMENT_INFO_PAGE = ADD_ON_PREFIX + "/" + Braintreeb2baddonConstants.EXTENSIONNAME + "/pages/login/savePaymentInfo";

}
