/**
 *
 */
package com.braintree.payment.validators;

import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commercefacades.user.data.CountryData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.validation.BindingResult;

@UnitTest
public class BrainTreePaymentDetailsValidatorTest {

    private static final int EXCEPTED_ERROR_NUMBER = 6;
    private BrainTreePaymentDetailsValidator unit;

    @Before
    public void setUp() {
        unit = new BrainTreePaymentDetailsValidator();
    }

    @Test
    public void validatePaymentDetailsShouldReturnExceptedNumberOfErrors() {
        final AddressData addressData = Mockito.mock(AddressData.class);
        final CountryData countryData = Mockito.mock(CountryData.class);
        final BindingResult bindingResult = Mockito.mock(BindingResult.class);
        when(addressData.getCountry()).thenReturn(countryData);

        unit.validatePaymentDetails(addressData, bindingResult);
        Assert.assertEquals(EXCEPTED_ERROR_NUMBER, unit.validatePaymentDetails(addressData, bindingResult).size());
    }
}
