function checkIntentOption(paypalIntent) {
    var isIntentValid = true;
    if (paypalIntent !== CONST.INTENT_SALE && paypalIntent !== CONST.INTENT_ORDER
        && paypalIntent !== CONST.INTENT_AUTHORIZE && paypalIntent !== CONST.INTENT_CAPTURE) {
        isIntentValid = false;
        return isIntentValid;
    } else {
        return isIntentValid;
    }
}

function processExpressCheckoutForm(paypalResponse, forceVault, deviceDataValue, isMiniCartCheckout, addressForOverriding) {
    var payPalForm;
    var isSavePaymentInfo;

    if ((typeof addPaymentMethodsPage != 'undefined') && (typeof isMiniCartCheckout == 'undefined')) {
        payPalForm = createForm(CONST.PAYPAL_EXPRESS_FORM_NAME, ACC.config.encodedContextPath + "/braintree/paypal/checkout/add-payment-method");
    }
    else if ((typeof returnUrlAfterSave != 'undefined')) {
        payPalForm = createForm(CONST.PAYPAL_EXPRESS_FORM_NAME, ACC.config.encodedContextPath + "/" + returnUrlAfterSave);
    }
    else {
        payPalForm = createForm(CONST.PAYPAL_EXPRESS_FORM_NAME, ACC.config.encodedContextPath + "/braintree/paypal/checkout/express");
    }

    if ($(CONST.SAVE_PAYMENT_INFO_ID + ':' + CONST.PROP_CHECKED).val() === CONST.TRUE || forceVault === true) {
        isSavePaymentInfo = createHiddenParameter("isSaved", CONST.TRUE);
    } else {
        isSavePaymentInfo = createHiddenParameter("isSaved", CONST.FALSE);
    }

    if(typeof addressForOverriding != 'undefined'){
        paypalResponse.details.shippingAddress.recipientName=addressForOverriding.recipientName;
        paypalResponse.details.shippingAddress.phone=addressForOverriding.phone;
    }

    var paymentType = createHiddenParameter("payPalData", JSON.stringify(paypalResponse));
    var token = ACC.config.CSRFToken;
    var realToken = createHiddenParameter("CSRFToken", token);

    // collect device data for advanced fraud tools
    var collectDeviceData;
    if (typeof deviceDataValue != 'undefined') {
        collectDeviceData = createHiddenParameter("device_data", deviceDataValue);
    } else {
        collectDeviceData = createHiddenParameter("device_data", this.deviceData);
    }
    payPalForm.append($(isSavePaymentInfo));
    payPalForm.append($(collectDeviceData));
    payPalForm.append($(paymentType));
    payPalForm.append($(realToken));
    payPalForm.appendTo('body');

    payPalForm.submit();
}

function processResponce(responce, deviceDataValue) {

    var submitForm = $('#' + CONST.BRAINTREE_PAYMENT_FORM_ID);

    var useDeliveryAddress = $(CONST.USE_DELIVERY_ADDRESS_ID).is(HTML.CHECKED);
    var useDelivery = createHiddenParameter("use_delivery_address", useDeliveryAddress);
    var paymentType = createHiddenParameter(CONST.PAYMENT_TYPE, responce.type);
    var cardType = createHiddenParameter(CONST.CARD_TYPE, responce.details.cardType);
    var cardDetails = createHiddenParameter(CONST.CARD_DETAILS,
        responce.details.lastFour);
    var expiresMonth = createHiddenParameter(CONST.CARD_EXPIRES_MONTH,
        responce.details.expirationMonth);
    var expiresYear = createHiddenParameter(CONST.CARD_EXPIRES_YEAR,
        responce.details.expirationYear);

    var isLiabilityShifted = '';

    var paymentNonce = createHiddenParameter(CONST.PAYMENT_METHOD_NONCE,
        responce.nonce);
    submitForm.append($(paymentNonce));
    if (typeof responce.liabilityShifted != 'undefined') {
        isLiabilityShifted = responce.liabilityShifted;
    }

    var liabilityShifted = createHiddenParameter(CONST.LIABILITY_SHIFTED,
        isLiabilityShifted);
    submitForm.append($(liabilityShifted));

    // collect device data for advanced fraud tools
    var deviceData;
    if (typeof deviceDataValue != 'undefined') {
        deviceData = createHiddenParameter(CONST.DEVICE_DATA, deviceDataValue);
    } else {
        deviceData = createHiddenParameter(CONST.DEVICE_DATA, this.deviceData);
    }

    var is3dSecureFlowData;
    if (typeof responce.is3dSecureFlow != 'undefined' && responce.is3dSecureFlow) {
        is3dSecureFlowData = createHiddenParameter(CONST.IS_3D_SECURE_FLOW, true);
    } else {
        is3dSecureFlowData = createHiddenParameter(CONST.IS_3D_SECURE_FLOW, false);
    }

    var cardholder = createHiddenParameter(CONST.CARDHOLDER, responce.details.cardholderName);

    submitForm.append($(is3dSecureFlowData));
    submitForm.append($(deviceData));
    submitForm.append($(useDelivery));
    submitForm.append($(paymentType));
    submitForm.append($(cardType));
    submitForm.append($(cardDetails));
    submitForm.append($(expiresMonth));
    submitForm.append($(expiresYear));
    submitForm.append($(cardholder));

    submitForm.submit();
}

function createForm(name, action) {
    var form = $(HTML.FORM).attr(CONST.ATTR_ACTION, action)
        .attr(CONST.ATTR_NAME, name).attr(CONST.ATTR_METHOD, CONST.FORM_METHOD_POST);
    return form;
}

function createHiddenParameter(name, value) {
    var input = $(HTML.INPUT).attr(HTML.TYPE, "hidden").attr(CONST.ATTR_NAME, name).val(
        value);
    return input;
}

function disablePlaceOrderButton() {
    document.getElementById('placeOrder').disabled = true;
}

function checkSavedPaymentMethods(paymentType, isAvailable) {
    const payments =  $('.paymentType');
    var  isEnabledPayment = isPaymentEnabled(paymentType);

    payments.each(function () {
        if (($(this).val() === paymentType) && (!isAvailable || !isEnabledPayment)) {
            $(this).next().remove();
            $(this).remove();
            console.log($(this).val());
        } else {
            if (canRemoveHide($(this).val(), paymentType)) {
                $(this).next().removeClass(CONST.HIDE);
            }
        }
    });

    if (typeof paymentMethodsPage != 'undefined') {
        if (!anotherPaymentPresent(payments, paymentType) && (!isAvailable || !isEnabledPayment)) {
            $('#savePaymentButton').remove();
        } else {
            $('#savePaymentButton').removeClass(CONST.HIDE);
        }
    }
}

function canRemoveHide(elem, type){
    if (elem===CONST.VENMO_ACCOUNT && type !== CONST.VENMO_ACCOUNT){
        return false;
    }

    if (elem===CONST.GOOGLE_PAY_ACCOUNT && type !== CONST.GOOGLE_PAY_ACCOUNT){
        return false;
    }
    return true;
}

function anotherPaymentPresent(payments, paymentType){
    return payments.toArray().some(value => value['value']!==paymentType);
}

function isPaymentEnabled(paymentType){
    if (paymentType===CONST.VENMO_ACCOUNT){
        return  venmoEnabled;
    }else if (paymentType===CONST.GOOGLE_PAY_ACCOUNT){
        return googlePayEnabled;
    }

    return false;
}

function configurePayPalAlongWithHostedFields() {

    // remove paypal validation messages
    $(CONST.GLOBAL_MESSAGES).children(CONST.VALIDATION_CLASS).remove();

    // add select payment method event
    $(CONST.PAYMENT_METHOD_SECTION).change(function () {
        paymentMethod();
    });

    // render appropriate payment method
        selectPaymentMethod();
}



function selectPaymentMethod() {
    if (typeof isCreditCardSelect != 'undefined' && isCreditCardSelect !== '' && isCreditCardSelect === "true") {
        $(CONST.CREDIT_CARD_PAYMENT_METHOD_ID).prop(CONST.PROP_CHECKED, true);
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).attr('type', 'submit');
    } else if (typeof isSingleUseSelect != 'undefined' && isSingleUseSelect !== '') {
        $(CONST.PAYMENT_METHOD_PAYPAL).prop(CONST.PROP_CHECKED, true);
        // select paypal as default
    } else {
        $(CONST.PAYMENT_METHOD_PAYPAL).prop(CONST.PROP_CHECKED, true);
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).attr('type', 'button');
        if(isAvailableVenmo()){
            $(CONST.VENMO_SELECTOR).removeClass(CONST.HIDE);
        } else {
            $(CONST.VENMO_SELECTOR).remove();
        }

        disableRadioButton();
    }
    triggerCheckedPaymentMethod();
}


function disableRadioButton() {
    var radioButtons = $(CONST.PAYMENT_METHOD_SECTION);
    if (radioButtons.length === 1) {
        radioButtons.prop(CONST.PROP_CHECKED, true);
        radioButtons.hide();
    } else if (radioButtons.length === 0) {
        $(CONST.NO_PAYMENT_METHODS_MESSAGE).removeClass('hidden');
        paymentMethod();
    } else if (!radioButtons.is(HTML.CHECKED)) {
        radioButtons.filter(':first').prop(CONST.PROP_CHECKED, true);
    }
}

function triggerCheckedPaymentMethod(){
    var radioButtons = $(CONST.PAYMENT_METHOD_SECTION);
    radioButtons.filter(HTML.CHECKED).trigger(EVENTS.CHANGE);
}

function paymentMethod() {
    if (isPayPalMethodSelected()) {
        $(CONST.SRC_BUTTON).hide();
        $(CONST.MARK_PAYPAL_BUTTON).show();
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).hide();
        $(CONST.VENMO_BUTTON).hide();
        $(CONST.GOOGLE_PAY_BUTTON).hide();
        $(CONST.APPLE_PAY_BUTTON).hide();
        $(CONST.HOSTED_FIELDS).hide();
        $(CONST.LPM_BUTTONS).hide();
        $(CONST.BILLING_ADDRESS_DATA).hide();
        $(CONST.CREADIT_CARD_LABEL_ID).removeClass(CONST.HEADLINE);
        $(CONST.PAYPAL_CMS_IMAGE_SELECTOR).removeClass(CONST.DISABLE_CLICK);
        $(CONST.SELECT_PAYMENT).val(CONST.PAYPAL);
        $(CONST.GLOBAL_MESSAGES).children(CONST.VALIDATION_CLASS).remove();
        if (paypalIntent === CONST.INTENT_ORDER) {
            $(CONST.SAVE_PAYMENT_INFO_COMPONENT).hide();
        } else {
            $(CONST.SAVE_PAYMENT_INFO_COMPONENT).show();
        }
    } else if (isApplePaySelected()) {
        $(CONST.SRC_BUTTON).hide();
        $(CONST.LPM_BUTTONS).hide();
        $(CONST.GOOGLE_PAY_BUTTON).hide();
        $(CONST.APPLE_PAY_BUTTON).show();
        $(CONST.VENMO_BUTTON).hide();
        $(CONST.HOSTED_FIELDS).hide();
        $(CONST.BILLING_ADDRESS_DATA).hide();
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).hide();
        $(CONST.MARK_PAYPAL_BUTTON).hide();
        $(CONST.CREADIT_CARD_LABEL_ID).removeClass(CONST.HEADLINE);
        $(CONST.SELECT_PAYMENT).val(CONST.APPLEPAY_VAL);
        $(CONST.GLOBAL_MESSAGES).children(CONST.VALIDATION_CLASS).remove();
        $(CONST.SAVE_PAYMENT_INFO_COMPONENT).hide();
        $(CONST.SAVE_PAYMENT_INFO_COMPONENT).prop("checked", false);
    } else if (isGooglePaySelected()) {
        $(CONST.SRC_BUTTON).hide();
        $(CONST.GOOGLE_PAY_BUTTON).show();
        $(CONST.APPLE_PAY_BUTTON).hide();
        $(CONST.VENMO_BUTTON).hide();
        $(CONST.LPM_BUTTONS).hide();
        $(CONST.HOSTED_FIELDS).hide();
        $(CONST.BILLING_ADDRESS_DATA).hide();
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).hide();
        $(CONST.MARK_PAYPAL_BUTTON).hide();
        $(CONST.CREADIT_CARD_LABEL_ID).removeClass(CONST.HEADLINE);
        $(CONST.GLOBAL_MESSAGES).children(CONST.VALIDATION_CLASS).remove();
        $(CONST.SAVE_PAYMENT_INFO_COMPONENT).show();
    } else if (isLocalPaymentsSelected()) {
        $(CONST.SRC_BUTTON).hide();
        $(CONST.LPM_BUTTONS).show();
        $(CONST.VENMO_BUTTON).hide();
        $(CONST.GOOGLE_PAY_BUTTON).hide();
        $(CONST.APPLE_PAY_BUTTON).hide();
        $(CONST.HOSTED_FIELDS).hide();
        $(CONST.BILLING_ADDRESS_DATA).hide();
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).hide();
        $(CONST.MARK_PAYPAL_BUTTON).hide();
        $(CONST.CREADIT_CARD_LABEL_ID).removeClass(CONST.HEADLINE);
        $(CONST.GLOBAL_MESSAGES).children(CONST.VALIDATION_CLASS).remove();
        $(CONST.SAVE_PAYMENT_INFO_COMPONENT).hide();
        $(CONST.SAVE_PAYMENT_INFO_COMPONENT).prop("checked", false);
    } else if (isVenmoSelected()) {
        $(CONST.SRC_BUTTON).hide();
        $(CONST.VENMO_BUTTON).show();
        $(CONST.LPM_BUTTONS).hide();
        $(CONST.GOOGLE_PAY_BUTTON).hide();
        $(CONST.APPLE_PAY_BUTTON).hide();
        $(CONST.HOSTED_FIELDS).hide();
        $(CONST.BILLING_ADDRESS_DATA).hide();
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).hide();
        $(CONST.MARK_PAYPAL_BUTTON).hide();
        $(CONST.CREADIT_CARD_LABEL_ID).removeClass(CONST.HEADLINE);
        $(CONST.GLOBAL_MESSAGES).children(CONST.VALIDATION_CLASS).remove();
        $(CONST.SAVE_PAYMENT_INFO_COMPONENT).show();
    } else if (isBrainTreeMethodSelected()){
        $(CONST.SRC_BUTTON).hide();
        $(CONST.LPM_BUTTONS).hide();
        $(CONST.GOOGLE_PAY_BUTTON).hide();
        $(CONST.APPLE_PAY_BUTTON).hide();
        $(CONST.VENMO_BUTTON).hide();
        $(CONST.HOSTED_FIELDS).show();
        $(CONST.BILLING_ADDRESS_DATA).show();
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).show();
        $(CONST.MARK_PAYPAL_BUTTON).hide();
        $(CONST.CREADIT_CARD_LABEL_ID).addClass(CONST.HEADLINE);
        $(CONST.PAYPAL_CMS_IMAGE_SELECTOR).addClass(CONST.DISABLE_CLICK);
        $(CONST.SELECT_PAYMENT).val("bt");
        $(CONST.SAVE_PAYMENT_INFO_COMPONENT).show();
    }else if (isSrcSelected()) {
        $(CONST.SRC_BUTTON).show();
        $(CONST.GOOGLE_PAY_BUTTON).hide();
        $(CONST.APPLE_PAY_BUTTON).hide();
        $(CONST.VENMO_BUTTON).hide();
        $(CONST.LPM_BUTTONS).hide();
        $(CONST.HOSTED_FIELDS).hide();
        $(CONST.BILLING_ADDRESS_DATA).hide();
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).hide();
        $(CONST.MARK_PAYPAL_BUTTON).hide();
        $(CONST.CREADIT_CARD_LABEL_ID).removeClass(CONST.HEADLINE);
        $(CONST.GLOBAL_MESSAGES).children(CONST.VALIDATION_CLASS).remove();
        $(CONST.SAVE_PAYMENT_INFO_COMPONENT).show();
    }else {
        $(CONST.SRC_BUTTON).hide();
        $(CONST.MARK_PAYPAL_BUTTON).hide();
        $(CONST.APPLE_PAY_BUTTON).hide();
        $(CONST.VENMO_BUTTON).hide();
        $(CONST.LPM_BUTTONS).hide();
        $(CONST.HOSTED_FIELDS).hide();
        $(CONST.BILLING_ADDRESS_DATA).hide();
        $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).hide();
        $(CONST.SAVE_PAYMENT_INFO_COMPONENT).hide();
        if (typeof addPaymentMethodsPage != 'undefined') {
            CONST.SAVE_PAYMENT_INFO_COMPONENT.hide();
        }
    }
}

function isApplePaySelected() {
    return $(CONST.PAYMENT_METHOD_SECTION_CHECKED).val() === CONST.APPLEPAY_VAL || $('input[name=onlyApplePaySelected]').val() === 'true';
}

function isBrainTreeMethodSelected() {
    return $(CONST.PAYMENT_METHOD_SECTION_CHECKED).val() === CONST.BT_VAL;
}

function isPayPalMethodSelected() {
    return $(CONST.PAYMENT_METHOD_SECTION_CHECKED).val() === CONST.PAYPAL_VAL || $('input[name=onlyPayPalSelected]').val() === 'true';
}

function isLocalPaymentsSelected() {
    return $(CONST.PAYMENT_METHOD_SECTION_CHECKED).val() === CONST.LOCAL_PAYMENTS_VAL || $('input[name=onlyLocalPaymentsSelected]').val() === 'true';
}

function isVenmoSelected() {
    return $(CONST.PAYMENT_METHOD_SECTION_CHECKED).val() === CONST.VENMO_VAL || $('input[name=onlyVenmoSelected]').val() === 'true';
}

function isGooglePaySelected() {
    return $(CONST.PAYMENT_METHOD_SECTION_CHECKED).val() === CONST.GOOGLEPAY_VAL || $('input[name=onlyGooglePaySelected]').val() === 'true';
}

function isSrcSelected() {
    return $(CONST.PAYMENT_METHOD_SECTION_CHECKED).val() === CONST.SRC || $('input[name=onlySrcSelected]').val() === 'true';
}

function showErrorMessage(message) { // Show messages as GlobalMessages util (not pinned)
    $(CONST.GLOBAL_MESSAGES).children(CONST.VALIDATION_CLASS).remove();
    var errorComponent = CONST.ERROR_DIV + message + HTML.DIV;
    $(CONST.GLOBAL_MESSAGES).append(errorComponent);
}

function showWarningMessage(message) {
    $(CONST.GLOBAL_MESSAGES).children(CONST.VALIDATION_CLASS).remove();
    var errorComponent = CONST.WARNING_DIV + message + HTML.DIV;
    $(CONST.GLOBAL_MESSAGES).append(errorComponent);
}

function showCustomAbsoluteErrorMessage(message) { // Show message pinned to the top of page
    $(CONST.SKIP_TO_CONTENT).empty();
    var errorComponent = $(HTML.DIV).attr(HTML.CLASS, CONST.ERROR_ALERT_SHIPPING_ADDRESS);
    errorComponent.prepend(message);
    $(CONST.SKIP_TO_CONTENT).append(errorComponent);
    setTimeout(function () {
        $(CONST.SKIP_TO_CONTENT).empty();
    }, 7000);
}

function changeApplePayButtonShape(shape) {
    if (shape === 'squareCorners') {
        document.getElementById(CONST.APPLE_PAY_BUTTON_ID).style = 'border-radius: 0px';
    } else if (shape === 'pill-shaped') {
        document.getElementById(CONST.APPLE_PAY_BUTTON_ID).style = 'border-radius: 15px';
    }
}

function is3DSecureEnabled() {
  return typeof secure3d !== 'undefined' && JSON.parse(secure3d);
}

function isSecure3dFallbackEnabled(payload) {
  const environment = payload.authenticationInsight.regulationEnvironment;
  return typeof secure3dFallback !== 'undefined' && secure3dFallback
                    && (environment === 'psd2' || environment === 'unavailable');
}

function is3DSecureOnMyAccountEnabled() {
  return typeof cc3dSecureVerificationOnMyAccount !== 'undefined' && JSON.parse(cc3dSecureVerificationOnMyAccount);
}

function isMarkCheckoutPage(){
  return typeof paymentMethodsPage != 'undefined' && paymentMethodsPage !== '';
}

function isShoppingCartPage(){
  return typeof shoppingCart != 'undefined' && shoppingCart !== '';
}
