jQuery(document).ready(function ($) {


    // add payment method images to footer section for all pages
    addPaymentMethodImagesToFooter();

    if (isAvailableApplePay()) {
        disableApplePay();
        $(CONST.APPLEPAY_SELECTOR).removeClass(CONST.HIDE);
        if (typeof applePayEnabled !== 'undefined' && applePayEnabled
            && !dropInEnabled && (isShoppingCartPage() || isMarkCheckoutPage())) {
            changeApplePayButtonShape(applePayShape);
        }
    } else {
        $(CONST.APPLEPAY_SELECTOR).remove();
    }

    // PayPal along with Hosted Fields checkout configuration
    if ((typeof paymentMethodsPage != 'undefined')) {
        //check if google pay supported display radio
        if (dropInEnabled) {
            initializeDropIn(createPayPalOptions());
        } else {
            checkVenmoPaymentMethods();
            createClientInstance(CONST.GLOBAL_MESSAGES, function () {
                if (googlePayEnabled) {
                    initialiseGooglePay();
                }
                configurePayPalAlongWithHostedFields();
            })
        }
    }

    if (typeof accountPaymentInfoPage != 'undefined') {
        enableShippingAddress = "false";
        configureAccountPaymentInfoPage();
    }

    if ((typeof addPaymentMethodsPage != 'undefined')) {
        enableShippingAddress = "false";
        if (dropInEnabled) {
            if(typeof accountPage !== 'undefined' && accountPage === 'accountAddPaymentMethodPage'){
                if ((document.getElementsByClassName(CONST.DROP_IN_ADD_PAYMENT_CONTAINER)[0]) !== undefined) {
                    initializeDropIn(createPayPalOptions());
                }
            } else {
                initializeDropIn(createPayPalOptions());
            }
        } else {
            checkVenmoPaymentMethods();
            createClientInstance(CONST.GLOBAL_MESSAGES, function () {
                if (googlePayEnabled) {
                    initialiseGooglePay();
                }
                configurePayPalAlongWithHostedFields();
            })
        }
    }

    // PayPal Shopping Cart Shortcut checkout configuration
    if (typeof shoppingCart != 'undefined' && shoppingCart !== '') {
        configurePaypalShortcut(CONST.PAYPAL_BUTTON);
    }

    if (typeof isCreditMessagesEnabled != 'undefined' && typeof shoppingCart == 'undefined') {
        configurePageForCreditMessage();
    }
    //Render button for automatic PM adding
    if (typeof savePaymentInfoPage != 'undefined' && savePaymentInfoPage === 'savePaymentInfoPage'){
        addBrainTreeLibrary(function () {
            createClientInstance(CONST.GLOBAL_MESSAGES, function(){
                createPayPalPaymentMarkFlow(createPayPalOptions());
            })
        });
    }
});



$(CONST.CREDIT_CARD_PAYMENT_METHOD_ID).change(function () {
    resetHostedFields();
    createHostedFields();
});

$(CONST.PAYMENT_METHOD_PAYPAL).change(function () {
    createPayPalPaymentMarkFlow(createPayPalOptions());
});

$(CONST.PAYMENT_METHOD_APPLE_PAY).change(function () {
    createApplePay(createPayPalOptions(), CONST.APPLE_PAY_BUTTON_SELECTOR, function (payload) {
        processApplePayResponseExpressCheckout(payload);
    });
});

$(CONST.PAYMENT_METHOD_GOOGLE_PAY).change(function () {
    resetHostedFields();
    if ($(CONST.GOOGLE_PAY_BUTTON).length > !1 && $(CONST.GOOGLE_PAY_BUTTON).is(":empty")) {
        setupGooglePayButton();
    }
});


$(CONST.PAYMENT_METHOD_LOCAL_PAYMENT).change(function () {
    resetHostedFields();
    createLocalPayment();
});

$(CONST.PAYMENT_METHOD_SRC).change(function () {
    resetHostedFields();
    initializeSrc();
});

let isVenmoInitialized = false;
$(CONST.PAYMENT_METHOD_VENMO).change(function () {
    if(isVenmoInitialized){
        return;
    }
    resetHostedFields();
    renderVenmoButton();
    isVenmoInitialized = true;
});

$("form[id^='savedPaymentInfoForm']").on('submit', function (e) {
    $("button[id^='useSelectedPaymentMethod']").attr("disabled", true);
    initialise3dSecure(e);
});

function addPaymentMethodImagesToFooter() {
    var paymentOptionsTextDiv = $(HTML.DIV).attr(HTML.CLASS, CONST.PAYMENT_OPTIONS);
    var br = $(HTML.BR);
    $(CONST.FOOTER).prepend(br);
    $(CONST.FOOTER).prepend(br);
    $(CONST.FOOTER).prepend(paymentOptionsTextDiv);
    var paymentOptionsImage = $(HTML.IMG);
    paymentOptionsImage
        .attr(
            HTML.SRC,
            CONST.FOOTER_IMG_SRC);
    paymentOptionsImage.attr(HTML.ALT, CONST.PAYMENT_OPTIONS_TEXT);
    $(HTML.FOOTER).children(CONST.CONTAINER_CLASS).append(paymentOptionsImage);
}

function activatePaypalStandardImage() {
    $(CONST.PAYPAL_CHECKOUT_IMAGE_SELECTOR).hover(function () {
        $(this).css('cursor', 'pointer');
    });
}

function selectIsSingleCheckbox() {
    if (JSON.parse(singleUse)) {
        $(CONST.SINGLE_USE_CHECKBOX_ID).prop(CONST.PROP_CHECKED, false);
        // initialize standard paypal by braintree
        initialisePaypal(CONST.PAYPAL_BUTTON);
    } else {
        $(CONST.SINGLE_USE_CHECKBOX_ID).prop(CONST.PROP_CHECKED, true);
        // initialize standard paypal by braintree
        initialisePaypal(CONST.PAYPAL_BUTTON);
    }
}

function showRemovePaymentDetailsConfirmation(paymentInfoID) {
    $.colorbox({
        href: "#popup_confirm_payment_removal_" + paymentInfoID,
        inline: true,
        maxWidth: "100%",
        opacity: 0.7,
        width: "320px",
        onComplete: function () {
            $(this).colorbox.resize();
        }
    });
}

function bindToColorboxClose() {
    $.colorbox.close();
}

function receiveNewAddressData(selectedAddressID) {
    $.ajax({
        url: ACC.config.encodedContextPath + '/my-account/receive-address',
        type: 'GET',
        data: { "selectedAddressCode": selectedAddressID },
        success: function (result) {
            var selectedAddress = $.parseJSON(result);
            $("#title").text(selectedAddress.title);
            $("#firstName").text(selectedAddress.firstName);
            $("#lastName").text(selectedAddress.lastName);
            $("#line1").text(selectedAddress.line1);
            $("#line2").text(selectedAddress.line2);
            $("#town").text(selectedAddress.town);
            $("#postalCode").text(selectedAddress.postalCode);
            $("#country-name").text(selectedAddress.country.name);
            if (selectedAddress.region != null) {
                $("#region-name").text(selectedAddress.region.name);
            } else {
                $("#region-name").text("");
            }
            $("#billingAddressId").val(selectedAddress.id);
        }
    });
    $.colorbox.close();
}
