<%@ page import="com.braintree.hybris.data.PayPalCheckoutData" %>
<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ taglib prefix="template" tagdir="/WEB-INF/tags/responsive/template"%>
<%@ taglib prefix="importData" tagdir="/WEB-INF/tags/addons/braintreeaddon/responsive/util/pages" %>
<spring:url value="/" var="homeUrl"/>

<template:page pageTitle="${pageTitle}" hideHeaderLinks="true">
    <jsp:body>
        <c:choose>
            <c:when test="${not shouldSavePaymentInfo}">
                <div class="save-payment-info-container">
                    <p id="save-payment-info-text">
                        <spring:theme code="paypal.connect.registration.save.address.info"/>
                    </p>
                    <div class="save-payment-info">
                        <div class="save-payment-info-form-action row">
                            <form:form id="savePaymentInfo" method="POST" action="${homeUrl}${saveAddressAndPaymentInfos}">
                                <button data-theme="b" type="submit"
                                        class="save-payment-info-button btn btn-primary btn-block"> Yes </button>
                            </form:form>
                        </div>
                        <div class="save-payment-info-form-action row">
                            <form:form method="POST" action="${homeUrl}${notSavePaymentAndAddressInfos}">
                                <button data-theme="b" type="submit"
                                        class="save-payment-info-button btn btn-primary btn-block"> No </button>
                                <div id="errorMessage"><span></span></div>
                            </form:form>
                        </div>
                    </div>
                </div>
            </c:when>
            <c:otherwise>
                <div class="save-payment-info-container">
                    <form:form method="POST"
                               action="${homeUrl}${notSavePaymentAndAddressInfos}">
                        <p id="save-payment-info-text">
                            <c:choose>
                                <c:when test="${not shouldSaveAddress}">
                                    <spring:theme code="paypal.connect.registration.save.payment.info"/>
                                </c:when>
                                <c:otherwise>
                                    <spring:theme code="paypal.connect.registration.save.payment.address.info"/>
                                </c:otherwise>
                            </c:choose>
                        </p>
                        <div class="save-payment-info">
                            <div class="save-payment-info-form-action row">
                                <importData:importPayPalConnectCheckoutData payPalCheckoutData="${payPalCheckoutData}" returnUrlAfterSave="${saveAddressAndPaymentInfos}"/>
                                <div id="mark-paypal-button" class="hide-pay-pal-btn"></div>
                                <button data-theme="b" type="submit"
                                        class="save-payment-info-button btn btn-primary btn-block"> Yes </button>
                                <button data-theme="b" type="submit"
                                        class="save-payment-info-button btn btn-primary btn-block"> No </button>
                                <div id="errorMessage"><span></span></div>
                            </div>
                        </div>
                    </form:form>

                    <form:form id="savePaymentInfo" method="POST" action="${homeUrl}${saveAddressAndPaymentInfos}">
                    </form:form>


                </div>
            </c:otherwise>
        </c:choose>
    </jsp:body>
</template:page>

