/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.braintree.controllers;

public interface BraintreeaddonControllerConstants {

    String ADDON_PREFIX = "addon:/braintreeaddon/";
    String CLIENT_TOKEN = "client_token";
    String PAY_PAL_CHECKOUT_DATA = "payPalCheckoutData";
    String IS_ADDRESS_OPEN = "is_credit_card_select";
    String PAY_PAL_CONFIGURATION_DATA = "payPalConfigurationData";
    String IS_USER_LOGGING_IN_FROM_LOGIN_PAGE = "IsUserLoggingInFromLoginPage";
    String PAYPAL_CONNECT_SERVLET_PATH = "/checkout";
    String BRAINTREE_PAYPAL_CONNECT_LOGIN_LINKED_ACCOUNTS = "braintree.paypal.connect.login.linked.accounts";
    String DISABLE_LOGIN_VIA_PAYPAL_TO_THE_EXISTING_USER_MESSAGE = "disable.login.via.paypal.to.the.existing.user.message";
    String BRAINTREE_PAYPAL_CONNECT_GLOBAL_ERROR = "braintree.paypal.connect.registration.global.error";
    String BRAINTREE_PAYPAL_CONNECT_REGISTRATION_MESSAGE_SET_UP_PASSWORD_FOR_NEW_USER = "braintree.paypal.connect.registration.message.set.up.password.for.new.user";
    String BRAINTREE_MY_ACCOUNT_TEXT_DROP_IN_LIMITED_DELETE_PAYMENT_METHODS = "braintree.myaccount.text.dropin.limited.delete.payment.methods";
    String CHECKOUT_MULTI_DELIVERY_ADDRESS_ADD = "/checkout/multi/delivery-address/add";

    //localized error messages
    String GENERAL_HEAD_ERROR = "braintree.checkout.general.error";
    String GENERAL_HEAD_ERROR_MESSAGE = "braintree.checkout.general.error.message";
    String BRAINTREE_CVV_VERIFICATION_ERROR = "checkout.multi.paymentMethod.cvv.verification.general.error";

    String PAY_PAL_GUEST_REGISTER_ERROR = "braintree.checkout.guest.error";
    String PAY_PAL_ADDRESS_ERROR = "braintree.paypal.shipping.error";
    String PAY_PAL_HAED_ERROR = "braintree.paypal.head.error";

    interface Views {

        interface Pages {

            interface MultiStepCheckout {

                String SilentOrderPostPage = ADDON_PREFIX + "pages/checkout/multi/silentOrderPostPage";
                String CheckoutOrderPageErrorPage = ADDON_PREFIX + "pages/checkout/multi/checkoutErrorPage";
                String CheckoutSummaryPage = ADDON_PREFIX + "pages/checkout/multi/checkoutSummaryPage";
                String FallbackPage = ADDON_PREFIX + "pages/checkout/multi/fallbackPage";
            }

            interface Checkout {

                String CheckoutConfirmationPage = ADDON_PREFIX + "pages/checkout/checkoutConfirmationPage";
                String CheckoutLoginPage = "pages/checkout/checkoutLoginPage";
            }

            interface Login {
                String SAVE_PAYMENT_INFO_PAGE = ADDON_PREFIX + "pages/login/savePaymentInfo";
            }

            interface Account {
                String AccountLoginPage = "pages/account/accountLoginPage";
            }
        }

        interface Fragments {

            interface Cart {

                String CartPopup = ADDON_PREFIX + "fragments/cart/cartPopup";
                String AddToCartPopup = ADDON_PREFIX + "fragments/cart/addToCartPopup";
            }
        }
    }
}
