/**
 *
 */
package com.braintree.validators.impl;

import static com.braintree.constants.Braintreeb2boccaddonWebConstants.FIELD_REQUIRED_MESSAGE_ID;

import com.braintree.hybris.data.ws.PayPalPaymentRequestWsDTO;
import com.braintree.validators.BrainTreeValidator;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public class BraintreePayPalPaymentRequestValidator implements BrainTreeValidator {

    @Override
    public boolean supports(final Class clazz)
    {
        return PayPalPaymentRequestWsDTO.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(final Object target, final Errors errors) {

        final PayPalPaymentRequestWsDTO paymentResponse = (PayPalPaymentRequestWsDTO) target;

        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "nonce", FIELD_REQUIRED_MESSAGE_ID);
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "type", FIELD_REQUIRED_MESSAGE_ID);

        Assert.notNull(paymentResponse.getDetails(), "Details object must not be null");
    }

}
