/**
 *
 */
package com.braintree.replenishment.dao.impl;

import static com.braintree.replenishment.dao.impl.DefaultBraintreeCartToOrderCronJobDao.GET_CRON_JOB_BY_PAYMENT_METHOD_TOKEN;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBraintreeBraintreeCartToOrderCronJobDaoTest {

    private static final String PAYMENT_METHOD_TOKEN = "TOKEN";
    @Mock
    private FlexibleSearchService flexibleSearchService;

    @InjectMocks
    private DefaultBraintreeCartToOrderCronJobDao unit;


    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void findCronJobsByPaymentMethodTokenShouldReturnExceptedList() {
        List<CartToOrderCronJobModel> exceptedList = new ArrayList<>();
        final Map<String, Object> params = new HashMap<String, Object>();
        params.put("paymentMethodToken", PAYMENT_METHOD_TOKEN);
        params.put("duplicate", Boolean.FALSE);
        FlexibleSearchQuery flexibleSearchQuery = new FlexibleSearchQuery(GET_CRON_JOB_BY_PAYMENT_METHOD_TOKEN);
        flexibleSearchQuery.addQueryParameters(params);
        flexibleSearchQuery.setResultClassList(Collections.singletonList(CartToOrderCronJobModel.class));
        SearchResult<CartToOrderCronJobModel> searchResult = Mockito.mock(SearchResult.class);
        when(flexibleSearchService.<CartToOrderCronJobModel>search(flexibleSearchQuery)).thenReturn(searchResult);
        when(searchResult.getResult()).thenReturn(exceptedList);

        List<CartToOrderCronJobModel> actualList = unit.findCronJobsByPaymentMethodToken(PAYMENT_METHOD_TOKEN);
        Assert.assertSame(exceptedList, actualList);
        verify(flexibleSearchService.search(flexibleSearchQuery));
    }

}
