/**
 *
 */
package com.braintree.replenishment.service.impl;

import com.braintree.replenishment.dao.BraintreeCartToOrderCronJobDao;
import com.braintree.replenishment.service.BrainTreeReplenishmentService;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.servicelayer.model.ModelService;
import java.util.List;

public class DefaultBrainTreeReplenishmentService implements BrainTreeReplenishmentService {

    private BraintreeCartToOrderCronJobDao cartToOrderDao;

    private ModelService modelService;

    @Override
    public void disableReplenishmentCronJobByPaymentMethodToken(String paymentMethodToken) {
        List<CartToOrderCronJobModel> replenishmentCronJobs =
            cartToOrderDao.findCronJobsByPaymentMethodToken(paymentMethodToken);
        if (replenishmentCronJobs != null) {
            replenishmentCronJobs.forEach(cartToOrderCronJobModel -> {
                cartToOrderCronJobModel.setActive(Boolean.FALSE);
                modelService.save(cartToOrderCronJobModel);
            });
        }
    }

    public BraintreeCartToOrderCronJobDao getCartToOrderDao() {
        return cartToOrderDao;
    }

    public void setCartToOrderDao(BraintreeCartToOrderCronJobDao cartToOrderDao) {
        this.cartToOrderDao = cartToOrderDao;
    }

    public ModelService getModelService() {
        return modelService;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }
}
