/**
 *
 */
package com.braintree.facade.impl;

import com.braintree.facade.BrainTreeB2BOrderFacade;
import com.braintree.util.BrainTreeUtils;
import de.hybris.platform.b2bacceleratorfacades.order.data.ScheduledCartData;
import de.hybris.platform.b2bacceleratorfacades.order.impl.DefaultB2BOrderFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;

public class DefaultBrainTreeB2BOrderFacade extends DefaultB2BOrderFacade implements BrainTreeB2BOrderFacade {

    @Override
    public boolean isCustomerHasActiveReplenishmentForSavedPayPalOrCreditCard() {
        return getReplenishmentHistory().stream()
            .filter(ScheduledCartData::isActive)
            .anyMatch(replenishment -> {
                CCPaymentInfoData paymentInfo = replenishment.getPaymentInfo();
                return BrainTreeUtils.isPayPalPayment(paymentInfo.getSubscriptionId())
                    || BrainTreeUtils.isCreditCardPayment(paymentInfo.getSubscriptionId());
            });
    }

}
