/**
 *
 */
package com.braintree.action;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.b2b.process.approval.actions.AbstractSimpleB2BApproveOrderDecisionAction;
import de.hybris.platform.b2b.process.approval.model.B2BApprovalProcessModel;
import de.hybris.platform.b2bacceleratorservices.enums.CheckoutPaymentType;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.task.RetryLaterException;
import org.apache.log4j.Logger;

public class BraintreeCheckCreditCartOrderAction extends AbstractSimpleB2BApproveOrderDecisionAction {

    private static final Logger LOG = Logger.getLogger(BraintreeCheckCreditCartOrderAction.class);

    @Override
    public Transition executeAction(B2BApprovalProcessModel process) throws RetryLaterException {
        OrderModel order = null;
        Transition transition = Transition.NOK;
        try {
            order = process.getOrder();
            final PaymentInfoModel paymentInfo = order.getPaymentInfo();

            if (CheckoutPaymentType.CARD.equals(order.getPaymentType())
                && paymentInfo instanceof CreditCardPaymentInfoModel) {
                // this is a credit card payment, approval is not required
                transition = Transition.OK;
            } else if (paymentInfo instanceof BrainTreePaymentInfoModel) {
                transition = Transition.OK;
            }
        } catch (final Exception e) {
            this.handleError(order, e);
        }
        return transition;
    }

    protected void handleError(final OrderModel order, final Exception exception) {
        if (order != null) {
            this.setOrderStatus(order, OrderStatus.B2B_PROCESSING_ERROR);
        }
        LOG.error(exception.getMessage(), exception);
    }
}
