/**
 *
 */
package com.braintree.payment.validators;

import com.braintree.exceptions.BraintreeResourceErrorMessage;
import com.braintree.payment.validators.impl.DefaultBraintreeEditPaymentMethodValidator;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UnitTest
public class DefaultBraintreeEditBraintreePaymentMethodValidatorTest {


    private static final String CARD_HOLDER = "cardHolder";
    private static final String CORRECT_EXPIRATION_DATE = "02/21";
    private static final String INCORRECT_EXPIRATION_DATE = "02/21/12";
    private static final String CORRECT_CVV = "cvv";
    private static final String INCORRECT_CVV = "cvvvvv";

    private static final String INVALID_CVV_MESSAGE_CODE =
        "text.account.profile.paymentCart.editPaymentMethod.invalid.cvv";

    private static final String INVALID_EXPIRATION_DATE_MESSAGE_CODE =
        "text.account.profile.paymentCart.editPaymentMethod.invalid.expirationDate";

    private static final String ABSENCE_EXPIRATION_DATE_MESSAGE_CODE =
        "text.account.profile.paymentCart.editPaymentMethod.required.expirationDate";
    private DefaultBraintreeEditPaymentMethodValidator unit;

    @Before
    public void setUp() {
        unit = new DefaultBraintreeEditPaymentMethodValidator();
    }


    @Test()
    public void testValidatorWithIncorrectCVV() {
        final BraintreeResourceErrorMessage resourceErrorMessage = unit.validate(CARD_HOLDER, CORRECT_EXPIRATION_DATE, INCORRECT_CVV);
        Assert.assertEquals(INVALID_CVV_MESSAGE_CODE, resourceErrorMessage.getMessageKey());
    }

    @Test
    public void testValidatorWithIncorrectExpirationDate() {
        final BraintreeResourceErrorMessage resourceErrorMessage = unit.validate(CARD_HOLDER, INCORRECT_EXPIRATION_DATE, CORRECT_CVV);
        Assert.assertEquals(INVALID_EXPIRATION_DATE_MESSAGE_CODE, resourceErrorMessage.getMessageKey());
    }

    @Test
    public void testValidatorWithWithoutExpirationDate() {
        final BraintreeResourceErrorMessage resourceErrorMessage = unit.validate(CARD_HOLDER, "", CORRECT_CVV);
        Assert.assertEquals(ABSENCE_EXPIRATION_DATE_MESSAGE_CODE, resourceErrorMessage.getMessageKey());
    }

    @Test
    public void testValidatorWithIncorrectExpirationDateLength() {
        final BraintreeResourceErrorMessage resourceErrorMessage = unit.validate(CARD_HOLDER, CORRECT_EXPIRATION_DATE, CORRECT_CVV);
        Assert.assertEquals(INVALID_EXPIRATION_DATE_MESSAGE_CODE, resourceErrorMessage.getMessageKey());
    }
}
