<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sptemplate" tagdir="/WEB-INF/tags/addons/secureportaladdon/responsive/sptemplate" %>
<%@ taglib prefix="spuser" tagdir="/WEB-INF/tags/addons/secureportaladdon/responsive/spuser" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="formElement" tagdir="/WEB-INF/tags/responsive/formElement" %>

<sptemplate:page pageTitle="${pageTitle}">
    <jsp:body>
        <div class="register__container">
        <div class="row" data-role="content">
            <div class="col-sm-10">
                <div class="register__section">
                    <div class="headline">
                        <spring:theme code="text.secureportal.register.new.customer"/>
                    </div>
                    <p>
                        <spring:theme code="braintree.paypal.connect.registration.page.description"/>
                    </p>

                    <div>
                        <form:form method="post" id="registerForm" modelAttribute="registrationForm">
                            <formElement:formSelectBox idKey="address.country_del" labelKey="address.country"
                                                       path="companyAddressCountryIso" mandatory="true"
                                                       skipBlank="false" skipBlankMessageKey="address.selectCountry"
                                                       items="${countries}"
                                                       itemValue="isocode" selectCSSClass="form-control"/>
                            <formElement:formSelectBox idKey="register.title" labelKey="register.title"
                                                       path="titleCode" mandatory="true"
                                                       skipBlank="false"
                                                       skipBlankMessageKey="form.select.none"
                                                       items="${titles}"
                                                       selectCSSClass="form-control"/>

                            <formElement:formInputBox idKey="text.secureportal.register.companyName"
                                                      labelKey="text.secureportal.register.companyName"
                                                      path="companyName"
                                                      inputCSS="form-control" mandatory="true"/>
                            <formElement:formInputBox idKey="address.line1" labelKey="address.line1"
                                                      path="companyAddressStreet"
                                                      inputCSS="form-control" mandatory="true"/>
                            <formElement:formInputBox idKey="address.line2" labelKey="address.line2"
                                                      path="companyAddressStreetLine2"
                                                      inputCSS="form-control" mandatory="false"/>
                            <formElement:formInputBox idKey="address.townCity" labelKey="address.townCity"
                                                      path="companyAddressCity"
                                                      inputCSS="form-control" mandatory="true"/>
                            <formElement:formInputBox idKey="address.postcode" labelKey="address.postcode"
                                                      path="companyAddressPostalCode"
                                                      inputCSS="form-control" mandatory="true"/>
                            <formElement:formInputBox idKey="text.secureportal.register.position"
                                                      labelKey="text.secureportal.register.position" path="position"
                                                      inputCSS="form-control"
                                                      mandatory="true"/>

                            <div class="row">
                                <div class="col-sm-10 phone">
                                    <formElement:formInputBox idKey="storeDetails.table.telephone"
                                                              labelKey="storeDetails.table.telephone"
                                                              path="telephone" inputCSS="form-control"
                                                              mandatory="true"/>
                                </div>
                            </div>

                            <div class="register-form-action row">
                                <div class="col-xs-12 col-md-6 pull-right">
                                    <ycommerce:testId code="register_Register_button">
                                        <button data-theme="b"
                                                class="js-secureportal-register-button btn btn-primary btn-block">
                                            <spring:theme code='braintree.paypal.connect.registration.request.continue'/>
                                        </button>
                                    </ycommerce:testId>
                                </div>
                            </div>

                        </form:form>
                    </div>
                </div>
            </div>
        </div>
    </jsp:body>
</sptemplate:page>
