<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="cart" tagdir="/WEB-INF/tags/responsive/cart" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags" %>
<%@ taglib prefix="importData" tagdir="/WEB-INF/tags/addons/braintreeb2baddon/responsive/util/pages" %>

<jsp:include page="../../../messages/braintreeErrorMessages.jsp"/>

<c:set var="payPalExpressEnabled" scope="session" value="${payPalCheckoutData.payPalPaymentMethod.payPalExpressEnabled}"/>
<c:set var="applePayEnabled" scope="session" value="${payPalCheckoutData.applePayPaymentMethod.applePayEnabled}"/>
<c:set var="applePayOnExpressCheckoutEnabled" scope="session" value="${payPalCheckoutData.applePayPaymentMethod.applePayOnExpressCheckoutEnabled}"/>
<c:set var="googlePayEnabled" scope="session" value="${payPalCheckoutData.googlePayPaymentMethod.googlePayEnabled}"/>
<c:set var="googlePayOnExpressCheckoutEnabled" scope="session" value="${payPalCheckoutData.googlePayPaymentMethod.googlePayOnExpressCheckoutEnabled}"/>
<c:set var="isAnonymousUser" scope = "session" value = "${isAnonymousUser}"/>
<c:set var="srcEnabled" scope="session" value="${payPalCheckoutData.srcPaymentMethod.srcEnabled}"/>
<c:set var="srcImgUrl" scope="session" value="${payPalCheckoutData.srcPaymentMethod.srcImgUrl}"/>
<c:set var="dropInEnabled" scope="session" value="${payPalCheckoutData.dropIn.dropInEnabled}"/>

<c:url value="/cart/checkout" var="checkoutUrl" scope="session"/>
<div class="row">
    <div class="col-xs-12 col-sm-10 col-md-7 col-lg-6 pull-right cart-actions--print">
        <div class="express-checkout">
            <div class="headline"><spring:theme code="text.expresscheckout.header"/></div>
            <strong><spring:theme code="text.expresscheckout.title"/></strong>
            <ul>
                <li><spring:theme code="text.expresscheckout.line1"/></li>
                <li><spring:theme code="text.expresscheckout.line2"/></li>
                <li><spring:theme code="text.expresscheckout.line3"/></li>
            </ul>
            <sec:authorize access="isFullyAuthenticated()">
                <c:if test="${expressCheckoutAllowed}">
                    <div class="checkbox">
                        <label>
                            <c:url value="/checkout/multi/express" var="expressCheckoutUrl" scope="session"/>
                            <input type="checkbox" class="express-checkout-checkbox" data-express-checkout-url="${expressCheckoutUrl}">
                            <spring:theme text="I would like to Express checkout" code="cart.expresscheckout.checkbox"/>
                        </label>
                    </div>
                </c:if>
            </sec:authorize>
        </div>
        <c:choose>
            <c:when test="${dropInEnabled}">
                <importData:importCartCheckoutData payPalCheckoutData="${payPalCheckoutData}" cartPage="cartPage"/>

                <c:choose>
                    <c:when test="${isAnonymousUser}">
                        <div style="display: none" id="dropin-container" class="dropin-container-express-checkout hidden"></div>
                    </c:when>
                    <c:otherwise>
                        <div id="dropin-container" class="dropin-container-express-checkout hidden"></div>
                    </c:otherwise>
                </c:choose>

                <div class="bt_center">
                    <c:if test="${isCreditMessagesEnabled}">
                        <div data-pp-message data-pp-placement="category"
                             data-pp-amount="${cartData.totalPrice.value}"
                             data-pp-style-layout="${creditMessageComponent.layout.code}"
                             data-pp-style-color="${creditMessageComponent.color}"
                             data-pp-style-ratio="${creditMessageComponent.ratio}"
                             data-pp-style-logo-type="${creditMessageComponent.logoType.code}"
                             data-pp-style-logo-position="${creditMessageComponent.logoPosition.code}"
                             data-pp-style-text-color="${creditMessageComponent.textColor.code}">
                        </div>
                    </c:if>
                </div>
                <div class="orSeparator bt_center">
                    <spring:theme code="braintree.cart.or"/>
                </div>

                <div class="cart-actions">
                    <div class="row">
                        <div class="col-sm-3 col-md-4 pull-right">
                            <button class="btn btn-primary btn-block btn--continue-checkout js-continue-checkout-button"
                                    data-checkout-url="${checkoutUrl}"><spring:theme code="checkout.checkout"/></button>
                        </div>

                        <div class="col-sm-5 pull-right">
                            <button class="btn btn-default btn-block btn--continue-shopping js-continue-shopping-button"
                                    data-continue-shopping-url="${continueShoppingUrl}"><spring:theme text="Continue Shopping"
                                                                                                      code="cart.page.continue"/></button>
                        </div>
                        <cart:saveCart/>
                    </div>
                </div>
            </c:when>
            <c:when test="${payPalExpressEnabled or applePayEnabled or googlePayEnabled or srcEnabled and !dropInEnabled}">
                <importData:importCartCheckoutData payPalCheckoutData="${payPalCheckoutData}" cartPage="cartPage"/>
                <script>
                  var payPalButtonConfig = ${payPalButtonConfig};
                  var googlePayButtonConfig = ${googlePayButtonConfig};
                  var payPalShouldBeSaved = "${payPalShouldBeSaved}";
                  var isCreditMessagesEnabled = "${isCreditMessagesEnabled}";
                  var contextPath = "${request.contextPath}";
                  var applePayShape = "${applePayButtonConfig.shape}";
                </script>
                <sec:authorize access="hasAnyRole('ROLE_ANONYMOUS')">
                    <script>
                      isAnonymous = true;
                    </script>
                </sec:authorize>
                <div class="row cart-actions">
                    <div id="paypal_express_error bt_right"></div>

                </div>
                <div class="row cart-actions">
                    <div class="col-sm-6">

                    </div>
                    <div class="col-sm-6">
                        <div class="bt_center">
                            <div id="paypal_express_error"></div>
                            <c:if test="${applePayEnabled and applePayOnExpressChekoutEnabled and !isAnonymousUser}">
                                <style>
                                    .apple-pay-button {
                                        display: inline-block;
                                        -webkit-appearance: -apple-pay-button;
                                        -apple-pay-button-type: ${applePayButtonConfig.type};
                                        -apple-pay-button-style: ${applePayButtonConfig.color};
                                        -apple-pay-button-border-radius: 0px;
                                    }
                                </style>
                                <div id="apple-pay-button" class="apple-pay-button apple-pay-button-container hide"></div>
                            </c:if>
                            <div id="paypal-button" class="paypal-button paypal_button_container paypal-button-horizontal"></div>
                            <c:if test="${isCreditMessagesEnabled}">
                                <div data-pp-message data-pp-placement="category"
                                     data-pp-amount="${cartData.totalPrice.value}"
                                     data-pp-style-layout="${creditMessageComponent.layout.code}"
                                     data-pp-style-color="${creditMessageComponent.color}"
                                     data-pp-style-ratio="${creditMessageComponent.ratio}"
                                     data-pp-style-logo-type="${creditMessageComponent.logoType.code}"
                                     data-pp-style-logo-position="${creditMessageComponent.logoPosition.code}"
                                     data-pp-style-text-color="${creditMessageComponent.textColor.code}">
                                </div>
                                </br>
                            </c:if>
                            <c:if test="${!payPalExpressEnabled || isAnonymousUser}">
                                <script>
                                  document.getElementById('paypal-button').style.display = "none";
                                </script>
                            </c:if>
                            <c:if test="${googlePayEnabled and googlePayOnExpressCheckoutEnabled and !isAnonymousUser}">
                                <div id="google-pay-button" class="google_pay_container"></div>
                            </c:if>
                            <c:if test="${srcEnabled and !isAnonymousUser}">
                                <div id="src-button" class="src_container">
                                    <img src="${srcImgUrl}" alt="Visa Checkout" class="v-button" role="button"/>
                                </div>
                            </c:if>
                        </div>
                        <div class="orSeparator bt_center">
                            <spring:theme code="braintree.cart.or"/>
                        </div>
                    </div>
                </div>
                <div class="cart-actions">
                    <div class="row">
                        <div class="col-sm-3 col-md-4 pull-right">
                            <button class="btn btn-primary btn-block btn--continue-checkout js-continue-checkout-button"
                                    data-checkout-url="${checkoutUrl}"><spring:theme code="checkout.checkout"/></button>
                        </div>

                        <div class="col-sm-5 pull-right">
                            <button class="btn btn-default btn-block btn--continue-shopping js-continue-shopping-button"
                                    data-continue-shopping-url="${continueShoppingUrl}"><spring:theme text="Continue Shopping"
                                                                                                      code="cart.page.continue"/></button>
                        </div>
                        <cart:saveCart/>
                    </div>
                </div>

            </c:when>

            <c:otherwise>
                <importData:importCartCheckoutData payPalCheckoutData="${payPalCheckoutData}" cartPage="cartPage"/>
                <script>
                  var isCreditMessagesEnabled = "${isCreditMessagesEnabled}";
                </script>

                <div class="row cart-actions">
                    <div class="col-sm-6"></div>

                    <div class="col-sm-6">
                        <div class="bt_center">

                            <div id="paypal-button" class="paypal-button paypal_button_container paypal-button-horizontal"></div>
                            <c:if test="${isCreditMessagesEnabled}">
                                <div data-pp-message data-pp-placement="category"
                                     data-pp-amount="${cartData.totalPrice.value}"
                                     data-pp-style-layout="${creditMessageComponent.layout.code}"
                                     data-pp-style-color="${creditMessageComponent.color}"
                                     data-pp-style-ratio="${creditMessageComponent.ratio}"
                                     data-pp-style-logo-type="${creditMessageComponent.logoType.code}"
                                     data-pp-style-logo-position="${creditMessageComponent.logoPosition.code}"
                                     data-pp-style-text-color="${creditMessageComponent.textColor.code}">
                                </div>
                                </br>
                            </c:if>
                            <c:if test="${!payPalExpressEnabled}">
                                <script>
                                  document.getElementById('paypal-button').style.display = "none";
                                </script>
                            </c:if>

                        </div>
                    </div>
                </div>

                <div class="cart-actions">
                    <div class="row">
                        <div class="col-sm-3 col-md-4 pull-right">
                            <button class="btn btn-primary btn-block btn--continue-checkout js-continue-checkout-button"
                                    data-checkout-url="${checkoutUrl}"><spring:theme code="checkout.checkout"/></button>
                        </div>

                        <div class="col-sm-5 pull-right">
                            <button class="btn btn-default btn-block btn--continue-shopping js-continue-shopping-button"
                                    data-continue-shopping-url="${continueShoppingUrl}"><spring:theme text="Continue Shopping"
                                                                                                      code="cart.page.continue"/></button>
                        </div>
                        <cart:saveCart/>
                    </div>
                </div>

            </c:otherwise>
        </c:choose>
    </div>
</div>

<c:if test="${showCheckoutStrategies && not empty cartData.entries}">
    <div class="cart-actions">
        <div class="row">
            <div class="col-xs-12 col-sm-5 col-md-3 col-lg-2 pull-right">
                <input type="hidden" name="flow" id="flow"/>
                <input type="hidden" name="pci" id="pci"/>
                <select id="selectAltCheckoutFlow" class="doFlowSelectedChange form-control">
                    <option value="multistep"><spring:theme code="checkout.checkout.flow.select"/></option>
                    <option value="multistep"><spring:theme code="checkout.checkout.multi"/></option>
                    <option value="multistep-pci"><spring:theme code="checkout.checkout.multi.pci"/></option>
                </select>
                <select id="selectPciOption" class="display-none">
                    <option value=""><spring:theme code="checkout.checkout.multi.pci.select"/></option>
                    <c:if test="${!isOmsEnabled}">
                        <option value="default"><spring:theme code="checkout.checkout.multi.pci-ws"/></option>
                        <option value="hop"><spring:theme code="checkout.checkout.multi.pci-hop"/></option>
                    </c:if>
                    <option value="sop"><spring:theme code="checkout.checkout.multi.pci-sop" text="PCI-SOP"/></option>
                </select>
            </div>
        </div>
    </div>
</c:if>
