<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags" %>
<%@ taglib prefix="util" tagdir="/WEB-INF/tags/addons/braintreeb2baddon/responsive/util" %>
<%@ taglib prefix="importData" tagdir="/WEB-INF/tags/addons/braintreeb2baddon/responsive/util/pages" %>

<jsp:include page="../../../messages/braintreeErrorMessages.jsp"/>
<spring:eval expression="@configurationService.configuration.getProperty('braintree.store.in.vault')" var="storeInVault"/>
<div id="globalMessages"></div>
<div class="container">
    <div class="account-section-content	 account-section-content-small">
        <div class="account-addressbook">
            <c:if test="${payPalCheckoutData.configurationData.storeInVault}">
            <c:if test="${empty selectedAddressCode}">
            <spring:theme code="account.payment.selectAddress" text="Please select Billing Address for Payment Method"/></div>
        <br/>
        </c:if>
        <c:if test="${empty deliveryAddresses}">
            <br/>
            <div class="emptyMessage"><spring:theme code="account.payment.noAddress" text="No Saved Addresses"/></div>
            <div class="col-xs-12 col-sm-6 col-md-5 accountAddAddress">
                <a href="add-address" class="btn btn-primary btn-block"><spring:theme code="text.account.addressBook.addAddress"
                                                                                      text="Add New Address"/></a>
            </div>
        </c:if>
        <c:if test="${empty selectedAddressCode}">
            <c:if test="${not empty deliveryAddresses}">
                <button id="viewAddressBook" class="btn btn-default js-address-book" type="button"> Address Book</button>
                <div id="savedAddressListHolder" class="clear">
                    <div id="addressbook">
                        <c:forEach items="${deliveryAddresses}" var="deliveryAddress" varStatus="status">
                            <div class="addressEntry">
                                <form action="${request.contextPath}/my-account/add-payment-method" method="GET">
                                    <input type="hidden" name="selectedAddressCode" value="${deliveryAddress.id}"/>
                                    <ul>
                                        <li>
                                            <strong>${fn:escapeXml(deliveryAddress.title)}&nbsp;
                                                    ${fn:escapeXml(deliveryAddress.firstName)}&nbsp;
                                                    ${fn:escapeXml(deliveryAddress.lastName)}</strong>
                                            <br>
                                                ${fn:escapeXml(deliveryAddress.line1)}&nbsp;
                                                ${fn:escapeXml(deliveryAddress.line2)}
                                            <br>
                                                ${fn:escapeXml(deliveryAddress.town)}
                                            <c:if test="${not empty deliveryAddress.region.name}">
                                                &nbsp;${fn:escapeXml(deliveryAddress.region.name)}
                                            </c:if>
                                            <br>
                                                ${fn:escapeXml(deliveryAddress.country.name)}&nbsp;
                                                ${fn:escapeXml(deliveryAddress.postalCode)}
                                        </li>
                                    </ul>
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <spring:theme code="account.payment.address.useThisAddress" text="Use this Address"/>
                                    </button>
                                </form>
                            </div>
                        </c:forEach>
                    </div>
                </div>
            </c:if>
        </c:if>

        <c:if test="${not empty selectedAddressCode}">
        <div class="no-payment-methods-message headline hidden"><spring:theme code="checkout.multi.paymentMethod.noPaymentMethods"/></div>
        <div class="account-section-header">
            <spring:theme code="account.payment.address.addPaymentMethod.title" text="Add Payment Method"/>
        </div>
        <br>
        <c:choose>
        <c:when test="${payPalCheckoutData.dropIn.dropInEnabled}">
            <ycommerce:testId code="paymentDetailsForm">
                <form:form id="braintree-payment-form"
                           action="${request.contextPath}/my-account/add-payment-method" method="POST">
                    <div id="dropin-container" class="dropin-container-add-payment-method hidden"></div>
                    <div id="spinner-container">
                        <div class="wait-spinner"></div>
                    </div>
                    <input type="hidden" name="paypal_email" id="paypal_email"/>
                    <input type="hidden" name="selectedAddressCode" id="selectedAddressCode" value="${selectedAddressCode}"/>
                </form:form>
            </ycommerce:testId>

            <div id="braintree-payment-form-button-container">
                <button id="submit-button" class="btn btn-primary btn-block btn--continue-checkout hidden submit-button-add-payment-method"
                        type="submit">
                    <spring:theme code="account.add.paymentMethod.save" text="Save"/>
                </button>
                <c:url value="/my-account/payment-details" var="accountPaymentMethodUrl"/>
                <a class="btn btn-block btn-default" href="${accountPaymentMethodUrl}">
                    <spring:theme code="account.add.paymentMethod.cancel" text="Cancel"/>
                </a>
            </div>
        </c:when>
        <c:otherwise>
        <c:choose>
            <c:when test="${payPalCheckoutData.googlePayPaymentMethod.googlePayEnabled}">
                <div style="overflow: auto;" id="googlepay" class="hide">
                    <input id="paymentMethodGooglePay" type="radio"
                           name="paymentMethodSelection" value="googlePay"
                           class="paypalselection"/>
                    <div id="google-pay-button-container">
                        <div class="cmsimage">
                            <img class="google-pay-image"
                                 src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/googlePay_mark.png"
                                 alt="Buy with GooglePay" class="payment-logo"/>
                        </div>
                    </div>
                </div>
                <br>
            </c:when>
            <c:otherwise>
                <div style="overflow: auto;"></div>
            </c:otherwise>
        </c:choose>
        <c:if test="${payPalCheckoutData.configurationData.intent ne 'order'}">
            <c:choose>
                <c:when test="${payPalCheckoutData.payPalPaymentMethod.payPalStandardEnabled}">
                    <div style="overflow: auto;" id="paypal-checkbox">
                        <input id="paymentMethodPayPal" type="radio"
                               name="paymentMethodSelection" value="paypal"
                               class="paypalselection" checked="true"/>
                        <div class="paypalimage" id="paypal-container">
                            <div class="cmsimage">
                                <img
                                        src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-medium.png"
                                        alt="Buy now with PayPal" class="payment-logo"/>
                            </div>
                        </div>
                        <div id="text" class="paypalurl">
                            <a style="padding-left: 10px;"
                               href="https://www.paypal.com/webapps/mpp/paypal-popup"
                               title="How PayPal Works"
                               onclick="javascript:window.open('https://www.paypal.com/webapps/mpp/paypal-popup','WIPaypal','toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=1060, height=700'); return false;"><spring:theme
                                    code="braintree.text.what.is.paypal"/>?</a>
                        </div>
                    </div>
                </c:when>
                <c:otherwise>
                    <div style="overflow: auto;"></div>
                </c:otherwise>
            </c:choose>
        </c:if>
        <br>
            <c:choose>
                <c:when test="${payPalCheckoutData.creditCardPaymentMethod.hostedFieldsEnable}">
                    <div style="overflow: auto;" id="braintree-container">
                        <input id="creditCardPaymentMethod" type="radio" name="paymentMethodSelection" value="bt"
                               class="paypalselection" checked="true"/>
                        <c:if test="${(not empty payPalCheckoutData.creditCardPaymentMethod.paymentsImagesUrl)}">
                            <c:forEach items="${payPalCheckoutData.creditCardPaymentMethod.paymentsImagesUrl}" var="url">
                                <img src="${url.value}" alt="${url.key}"/>
                            </c:forEach>
                        </c:if>
                        <input type="hidden" value="false" class="text" name="paypal_is_valid" id="paypal_is_valid">
                    </div>
                </c:when>
                <c:otherwise>
                    <div style="overflow: auto;"></div>
                </c:otherwise>
            </c:choose>
             <c:choose>
                <c:when test="${payPalCheckoutData.usBankAccountPaymentMethod.usBankAccountEnabled}">
                   <div style="overflow: auto;" id="usBankAccount">
                      <input id="paymentMethodUsBankAccount" type="radio"
                         name="paymentMethodSelection" value="usBankAccount"
                         class="paypalselection"/>
                      <div id="us-bank-account-mark-container">
                         <div class="cmsimage">
                            <img class="us-bank-account-mark payment-logo us-bank-logo-margin"
                               src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/us_bank_account_acceptance_mark.png"
                               alt="Us Bank Account" />
                         </div>
                      </div>
                   </div>
                </c:when>
                <c:otherwise>
                   <div style="overflow: auto;"></div>
                </c:otherwise>
          </c:choose>
        <c:choose>
            <c:when test="${payPalCheckoutData.venmoPaymentMethod.venmoEnabled}">
                <div style="overflow: auto;" id="venmo" class="hide">
                    <input id="paymentMethodVenmo" type="radio"
                           name="paymentMethodSelection" value="venmo"
                           class="paypalselection" checked="true"/>
                    <div id="venmo-mark-container">
                        <div class="cmsimage">
                            <img class="venmo-mark payment-logo"
                                 src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/venmo_acceptance_mark.svg"
                                 alt="Venmo"/>
                        </div>
                    </div>
                </div>
            </c:when>
            <c:otherwise>
                <div style="overflow: auto;"></div>
            </c:otherwise>
        </c:choose>
        <c:choose>
            <c:when test="${payPalCheckoutData.srcPaymentMethod.srcEnabled}">
                <div style="overflow: auto;" id="src">
                    <input id="paymentMethodSrc" type="radio"
                           name="paymentMethodSelection" value="src"
                           class="paypalselection"/>
                    <div id="src-button-container">
                        <div class="src-radio">
                            <label>
                                Buy with Secure Remote Commerce
                            </label>
                        </div>
                    </div>
                </div>
            </c:when>
            <c:otherwise>
                <div style="overflow: auto;"></div>
            </c:otherwise>
        </c:choose>

        <ycommerce:testId code="paymentDetailsForm">
        <div class="account-section-content">
            <form:form id="braintree-payment-form"
                       action="${request.contextPath}/my-account/add-payment-method" method="POST">
                <div class="hostedFields">
                    <div class="account-section-header">
                        <spring:theme code="checkout.multi.paymentMethod.addPaymentDetails.paymentCard" text="Card Details"/>
                    </div>
                    <div class="description">
                            <spring:theme code="checkout.multi.paymentMethod.addPaymentDetails.enterYourCardDetails"
                                    text="Please enter your card details for payment"/></br>
                    </div>
                    <div class="control-group cardForm" style="dispaly: none;" id="cardForn">
                        <label for="cardholderName" class="control-label ">
                            <spring:theme code="braintree.text.cc.cardholder"/>
                        </label>
                        <div class="controls">
                            <div id="cardholderName"></div>
                        </div>
                        <label for="number" class="control-label ">
                            <spring:theme code="braintree.text.cc.number"/></label>
                        <div id="number" class="controls"></div>
                        <label for="cvv" class="control-label ">
                            <spring:theme code="braintree.text.cc.cvv"/></label>
                        <div id="cvv" class="controls"></div>
                        <label for="expiration-date" class="control-label ">
                            <spring:theme code="braintree.text.cc.expiration.date"/></label>
                        <div id="expiration-date" class="controls"></div>
                    </div>
                </div>
                <br/>
                <div id="us-bank-account-container" class="paypal_button_container">
                    <div class="headline">
                       <h4>
                          <spring:theme code="usBankAccount.ach.direct.debit"/>
                       </h4>
                    </div>
                    <div class="description">
                       <h5>
                          <spring:theme code="usBankAccount.enter.details"/>
                       </h5>
                    </div>
                    <div>
                       <label for="account-number">
                          <spring:theme code="usBankAccount.account.number"/>
                       </label>
                       <br>
                       <input id="account-number" class="text form-control us-bank-account-fields" name="account-number" type="text" maxlength="17"><br>
                    </div>
                    <div>
                       <label for="routing-number">
                          <spring:theme code="usBankAccount.routing.number"/>
                       </label>
                       <br>
                       <input id="routing-number" class="text form-control us-bank-account-fields" name="routing-number" type="text" maxlength="9"><br>
                    </div>
                    <div>
                       <label for="account-type">
                          <spring:theme code="usBankAccount.account.type"/>
                       </label>
                       <br>
                       <select id="account-type" class="form-control us-bank-account-fields" name="account-type" >
                          <option value="checking" selected="selected">Checking</option>
                          <option value="savings">Savings</option>
                       </select>
                       <br>
                    </div>
                    <div>
                       <label for="ownership-type">
                          <spring:theme code="usBankAccount.ownership.type"/>
                       </label>
                       <br>
                       <select id="ownership-type" class="form-control us-bank-account-fields" name="ownership-type" onchange="showPersonalOrBusinessField(value)">
                          <option value="personal" selected="selected">Personal</option>
                          <option value="business">Business</option>
                       </select>
                       <br>
                    </div>
                    <div id="first-and-last-name-container">
                       <label for="first-name">
                          <spring:theme code="usBankAccount.first.name"/>
                       </label>
                       <br>
                       <input id="first-name" class="text form-control us-bank-account-fields" name="first-name" type="text"><br>
                       <label for="last-name">
                          <spring:theme code="usBankAccount.last.name"/>
                       </label>
                       <br>
                       <input id="last-name" class="text form-control us-bank-account-fields" name="last-name" type="text"><br>
                    </div>
                    <div id="business-name-container">
                       <label for="business-name">
                          <spring:theme code="usBankAccount.business.name"/>
                       </label>
                       <br>
                       <input id="business-name" class="text form-control" name="business-name" type="text"><br>
                    </div>
                    <div class="headline">
                       <h4>
                          <spring:theme code="usBankAccount.billing.address"/>
                       </h4>
                    </div>
                    <div>
                       <label for="billing-street-address">
                          <spring:theme code="usBankAccount.street.address"/>
                       </label>
                       <br>
                       <input id="billing-street-address" class="text form-control" name="billing-street-address" type="text"><br>
                    </div>
                    <div>
                       <label for="billing-extended-address">
                          <spring:theme code="usBankAccount.extended.address"/>
                       </label>
                       <br>
                       <input id="billing-extended-address" class="text form-control" name="billing-extended-address" type="text"><br>
                    </div>
                    <div>
                       <label for="billing-locality">
                          <spring:theme code="usBankAccount.city"/>
                       </label>
                       <br>
                       <input id="billing-locality" class="text form-control" name="billing-locality" type="text"><br>
                    </div>
                    <div>
                       <label for="billing-region">
                          <spring:theme code="usBankAccount.state"/>
                       </label>
                       <br>
                       <select id="billing-region" class="form-control" name="billing-region">
                          <c:forEach items="${regions}" var="region">
                             <option value="${region.isocodeShort}">
                                ${region.name}
                             </option>
                          </c:forEach>
                       </select>
                       </br>
                    </div>
                    <div>
                       <label for="billing-postal-code">
                          <spring:theme code="usBankAccount.postal.code"/>
                       </label>
                       <br>
                       <input id="billing-postal-code" class="text form-control" name="billing-postal-code" type="text"><br>
                    </div>
                 </div>
                 <div id="us-bank-account-text-and-button-container">
                    <div id="mandate-text">
                        <spring:message code="usBankAccount.text.save"
                                        arguments="${[payPalCheckoutData.usBankAccountPaymentMethod.merchantName]}"
                                        htmlEscape="false"
                        />
                    </div>
                     <br>
                     <div class="col-md-2 col-lg-3">
                         <input class="btn btn-primary btn-block" type="button" value="Save" onclick="" id="us-bank-account-button-continue">
                     </div>
                 </div>
                <input type="hidden" name="paypal_email" id="paypal_email"/>
                <input type="hidden" name="selectedAddressCode" id="selectedAddressCode" value="${selectedAddressCode}"/>
                <div class="form-additionals"/>
                <div class="form-actions">
                    <div class="col-md-2 col-lg-3">
                        <div id="venmo-button">
                            <div class="venmo-button-container">
                                <img src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/venmo_button.svg"
                                     alt="venmo logo" class="venmo-button-style"/>
                            </div>
                        </div>
                        <c:url value="/my-account/payment-details" var="accountPaymentMethodUrl"/>
                        <a class="btn btn-block btn-default" href="${accountPaymentMethodUrl}">
                            <spring:theme code="account.add.paymentMethod.cancel" text="Cancel"/>
                        </a>
                    </div>
                    <div class="col-md-2 col-lg-3">
                        <button class="btn btn-primary btn-block" id="submit_silentOrderPostForm" type="submit">
                            <spring:theme code="account.add.paymentMethod.save" text="Save"/>
                        </button>
                        <div id="mark-paypal-button" class="paypal_button_container btn btn-block"></div>
                        <div id="google-pay-button" class="google-pay-button-container google_pay_container"></div>
                        <div id="src-button" class="src-button-container src_container">
                            <img src="${payPalCheckoutData.srcPaymentMethod.srcImgUrl}" alt="Visa Checkout" class="v-button" role="button"/>
                        </div>
                    </div>
                </div>
            </form:form>
        </div>
    </div>
    </ycommerce:testId>
    </c:otherwise>
    </c:choose>
    </c:if>
    </c:if>
</div>
</div>
</div>

<script src="https://js.braintreegateway.com/js/braintree-2.26.0.min.js"></script>
<spring:eval expression="@configurationService.configuration.getProperty('braintree.user.action')" var="userAction"/>

<util:importBtSDK
        sdkVersion="3.85.3"
        enablePayPal="${payPalCheckoutData.payPalPaymentMethod.payPalStandardEnabled}"
        enableHostedFields="${payPalCheckoutData.creditCardPaymentMethod.hostedFieldsEnable}"
        enableGooglePay="${payPalCheckoutData.googlePayPaymentMethod.googlePayEnabled}"
        enableVenmo="${payPalCheckoutData.venmoPaymentMethod.venmoEnabled}"
        enableApplePay="${payPalCheckoutData.applePayPaymentMethod.applePayEnabled}"
        enableSecure3d="${payPalCheckoutData.creditCardPaymentMethod.secure3d}"
        enableUsBankAccount="${payPalCheckoutData.usBankAccountPaymentMethod.usBankAccountEnabled}"
        enableSecure3dFallback="${payPalCheckoutData.creditCardPaymentMethod.secure3dFallback}"
        enableSrc="${payPalCheckoutData.srcPaymentMethod.srcEnabled}"
        enableDropIn="${payPalCheckoutData.dropIn.dropInEnabled}"/>

<importData:importAccountCheckoutData payPalCheckoutData="${payPalCheckoutData}" accountPage="accountAddPaymentMethodPage"/>

<script>
  var isCreditCardSelect = "${is_credit_card_select}";
  var googlePayButtonConfig = ${googlePayButtonConfig};
  var isSingleUseSelect = "${is_single_use_select}";
  var deliveryAddressId = "${selectedAddressCode}";
  var amount = "0";
  var cc3dSecureVerificationOnMyAccount = "${payPalCheckoutData.creditCardPaymentMethod.secure3dOnMyAccount}";
  var secure3dFallback = "${payPalCheckoutData.creditCardPaymentMethod.secure3dFallback}";
</script>
