package com.braintree.validators;

import de.hybris.platform.secureportaladdon.forms.RegistrationForm;
import org.apache.commons.lang.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class BrainTreeConnectWithPayPalRegistrationValidator implements Validator {

    @Override
    public boolean supports(Class<?> aClass) {
        return RegistrationForm.class.equals(aClass);
    }

    @Override
    public void validate(final Object object, final Errors errors) {
        final RegistrationForm registrationForm = (RegistrationForm) object;
        final String addressLine1 = registrationForm.getCompanyAddressStreet();
        final String city = registrationForm.getCompanyAddressCity();
        final String companyName = registrationForm.getCompanyName();
        final String country = registrationForm.getCompanyAddressCountryIso();
        final String position = registrationForm.getPosition();
        final String postalCode = registrationForm.getcompanyAddressPostalCode();
        final String telephone = registrationForm.getTelephone();

        validateBlankText(errors, addressLine1, "companyAddressStreet");
        validateBlankText(errors, city, "companyAddressCity");
        validateBlankText(errors, companyName, "companyName");
        validateBlankText(errors, country, "companyAddressCountryIso");
        validateBlankText(errors, position, "position");
        validateBlankText(errors, postalCode, "companyAddressPostalCode");
        validateBlankText(errors, telephone, "telephone");
    }

    protected void validateBlankText(final Errors errors, final String name, final String propertyName) {
        if (StringUtils.isBlank(name)) {
            errors.rejectValue(propertyName, "text.secureportal.register.field.mandatory");
        }
    }

}