/**
 *
 */
package com.braintree.controllers.handler;

import static braintreehac.services.BrainTreeDropInConfigurationService.APPLE_PAY;
import static braintreehac.services.BrainTreeDropInConfigurationService.BILLING;
import static braintreehac.services.BrainTreeDropInConfigurationService.CART;
import static braintreehac.services.BrainTreeDropInConfigurationService.GOOGLE_PAY;
import static braintreehac.services.BrainTreeDropInConfigurationService.MINI_CART;
import static braintreehac.services.BrainTreeDropInConfigurationService.PAYPAL;
import static com.braintree.constants.BraintreeConstants.US_BANK_ACCOUNT;
import static com.braintree.constants.Braintreeb2baddonWebConstants.CREDIT_MESSAGE_COMPONENT;
import static com.braintree.constants.Braintreeb2baddonWebConstants.IS_ANONYMOUS_USER;
import static com.braintree.constants.Braintreeb2baddonWebConstants.IS_CREDIT_MESSAGE_ENABLED;
import static com.braintree.constants.Braintreeb2baddonWebConstants.PAYMENT_INFOS;
import static com.braintree.controllers.Braintreeb2baddonControllerConstants.CLIENT_TOKEN;
import static com.braintree.controllers.Braintreeb2baddonControllerConstants.PAY_PAL_CHECKOUT_DATA;
import static com.braintree.controllers.Braintreeb2baddonControllerConstants.Views.Pages.Checkout.CheckoutConfirmationPage;
import static com.braintree.controllers.Braintreeb2baddonControllerConstants.Views.Pages.Checkout.ReplenishmentCheckoutConfirmationPage;
import static com.braintree.controllers.Braintreeb2baddonControllerConstants.Views.Pages.MultiStepCheckout.CheckoutSummaryPage;
import static com.braintree.controllers.Braintreeb2baddonControllerConstants.Views.Pages.MultiStepCheckout.FallbackPage;
import static com.braintree.controllers.Braintreeb2baddonControllerConstants.Views.Pages.MultiStepCheckout.SilentOrderPostPage;
import static com.braintree.controllers.Braintreeb2baddonControllerConstants.BRAINTREE_MY_ACCOUNT_TEXT_DROP_IN_LIMITED_DELETE_PAYMENT_METHODS;
import static org.apache.commons.lang.StringUtils.isNotBlank;

import braintreehac.services.BrainTreeDropInConfigurationService;
import braintreehac.services.BrainTreeButtonConfigurationService;
import com.braintree.configuration.BrainTreeConfigurationListener;
import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.constants.BraintreeControllerConstants;
import com.braintree.controllers.Braintreeb2baddonControllerConstants;
import com.braintree.enums.BrainTreePaymentMethod;
import com.braintree.enums.BraintreePageType;
import com.braintree.facade.BrainTreeB2BOrderFacade;
import com.braintree.facade.BrainTreeSetUpPasswordFacade;
import com.braintree.facade.BrainTreeUserFacade;
import com.braintree.facade.impl.DefaultBrainTreeCheckoutFacade;
import com.braintree.facade.impl.DefaultBrainTreePaymentFacade;
import com.braintree.hybris.data.BrainTreePaymentInfoData;
import com.braintree.hybris.data.BraintreeLocalPaymentMethodData;
import com.braintree.hybris.data.BraintreeUserData;
import com.braintree.hybris.data.PayPalCheckoutData;
import com.braintree.model.PayPalCreditMessageComponentB2BModel;
import com.braintree.util.BrainTreeUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.addonsupport.interceptors.BeforeViewHandlerAdaptee;
import de.hybris.platform.b2bacceleratorfacades.order.data.ScheduledCartData;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.commercefacades.i18n.I18NFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.order.data.OrderData;
import de.hybris.platform.core.Registry;
import de.hybris.platform.servicelayer.session.SessionService;
import de.hybris.platform.util.config.ConfigIntf;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;


public class BrainTreeBeforeViewHandler implements BeforeViewHandlerAdaptee {

    private static final Logger LOG = Logger.getLogger(BrainTreeBeforeViewHandler.class);

    private static final String CART_PAGE = "pages/cart/cartPage";
    private static final String BRAIN_TREE_PAYMENT_DATA = "brainTreePaymentInfoData";
    private static final String ORDER_DATA = "orderData";
    private static final String B2C_ADD_TO_CART_POPUP_PAGE = "fragments/cart/addToCartPopup";
    private static final String B2C_CART_POPUP_PAGE = "fragments/cart/cartPopup";
    private static final String ACCOUNT_LAYOUT_PAGE = "pages/account/accountLayoutPage";
    private static final String PAYPAL_BUTTON_CONFIG = "payPalButtonConfig";
    private static final String PAYPAL_MARK_BUTTON_CONFIG = "payPalMarkButtonConfig";
    private static final String GOOGLE_PAY_BUTTON_CONFIG = "googlePayButtonConfig";
    private static final String APPLE_PAY_BUTTON_CONFIG = "applePayButtonConfig";
    private static final String B2C_CHECKOUT_CONFIRMATION_LAYOUT_PAGE = "pages/checkout/checkoutConfirmationLayoutPage";
    private static final String B2C_CHECKOUT_DELIVERY_ADDRESS_PAGE = "pages/checkout/multi/addEditDeliveryAddressPage";
    private static final String IS_STORE_IN_VAULT = "isStoreInVault";
    private static final String IS_REPLENISHMENT_AVAILABLE = "isReplenishmentAvailable";
    private static final String PAYPAL_CREDIT_MESSAGE = "PayPalCartPageCreditMessageComponentB2B";
    private static final String LPM_IDS = "lpmids";
    private static final String USER_DATA = "userData";
    private static final String REGIONS = "regions";
    private static final String CURRENT_DATE = "currentDate";
    private static final String US = "US";
    private static final String MERCHANT_NAME = "merchantName";
    private static final String B2B_SHOW_WARNING_MESSAGE_ON_EDIT_DROP_IN = "showWarningMessageAboutReplenishmentDropIn";
    private static final String GOOGLE_PAY_MINI_CART_DROP_IN_CONFIG = "googlePayMiniCartDropInConfig";
    private static final String GOOGLE_PAY_CART_DROP_IN_CONFIG = "googlePayCartDropInConfig";
    private static final String GOOGLE_PAY_BILLING_DROP_IN_CONFIG = "googlePayBillingDropInConfig";
    private static final String PAYPAL_MINI_CART_DROP_IN_CONFIG = "payPalMiniCartDropInConfig";
    private static final String PAYPAL_CART_DROP_IN_CONFIG = "payPalCartDropInConfig";
    private static final String PAYPAL_BILLING_DROP_IN_CONFIG = "payPalBillingDropInConfig";
    private static final String APPLE_PAY_MINI_CART_DROP_IN_CONFIG = "applePayMiniCartDropInConfig";
    private static final String APPLE_PAY_CART_DROP_IN_CONFIG = "applePayCartDropInConfig";
    private static final String APPLE_PAY_BILLING_DROP_IN_CONFIG = "applePayBillingDropInConfig";
    private static final String BRAINTREE_GENERAL_ERROR_SHIPPING_ADDRESS = "braintree.general.error.shippingAddress";
    private static final String SHOULD_SET_UP_PASSWORD_FORM_DISPLAYED ="shouldSetUpPasswordFormDisplayed";

    @Resource(name = "brainTreeCheckoutFacade")
    private DefaultBrainTreeCheckoutFacade brainTreeCheckoutFacade;
    @Resource(name = "brainTreeSetUpPasswordFacade")
    private BrainTreeSetUpPasswordFacade brainTreeSetUpPasswordFacade;
    @Resource(name = "brainTreePaymentFacadeImpl")
    private DefaultBrainTreePaymentFacade brainTreePaymentFacade;
    @Resource(name = "brainTreeUserFacade")
    private BrainTreeUserFacade brainTreeUserFacade;
    @Resource(name = "brainTreeConfigService")
    private BrainTreeConfigService brainTreeConfigService;
    @Resource(name = "cmsComponentService")
    private CMSComponentService cmsComponentService;
    @Resource(name = "i18NFacade")
    private I18NFacade i18NFacade;
    @Resource(name = "brainTreeB2BOrderFacade")
    private BrainTreeB2BOrderFacade brainTreeB2BOrderFacade;


    @Autowired
    private BrainTreeButtonConfigurationService payPalButtonConfigurationService;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private BrainTreeDropInConfigurationService dropInConfigurationService;

    private ConfigIntf.ConfigChangeListener configurationChangeListener;

    @Override
    public String beforeView(final HttpServletRequest request, final HttpServletResponse response, final ModelMap model,
        final String viewName) throws Exception {

        if ((!B2C_CART_POPUP_PAGE.equals(viewName) && !B2C_ADD_TO_CART_POPUP_PAGE.equals(viewName))
            && !isPaymentMethodsAvailable(viewName)) {
            return viewName;
        }
        model.addAttribute(SHOULD_SET_UP_PASSWORD_FORM_DISPLAYED,brainTreeSetUpPasswordFacade.isSetUpPasswordForm());
        return handleBrainTreeCheckoutScenario(model, viewName);

    }

    private String handleBrainTreeCheckoutScenario(final ModelMap model, final String viewName)
        throws CMSItemNotFoundException {

        if (configurationChangeListener == null) {
            registerConfigChangeLister();
        }

        if (CART_PAGE.equals(viewName)) {
            fillPaymentMethodsInfo(model, BraintreePageType.CART);
            final PayPalCreditMessageComponentB2BModel creditMessageComponent = cmsComponentService
                .getSimpleCMSComponent(PAYPAL_CREDIT_MESSAGE);
            model.addAttribute(CREDIT_MESSAGE_COMPONENT, creditMessageComponent);
            model.addAttribute(IS_CREDIT_MESSAGE_ENABLED, creditMessageComponent.getEnabled());
            model.addAttribute(IS_ANONYMOUS_USER, brainTreeUserFacade.isAnonymousUser());
            model.addAttribute(PAYPAL_BUTTON_CONFIG, payPalButtonConfigurationService.
                parsePayPalButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                    getPayPalButtonStyleByPageType(BraintreePageType.CART)));
            model.addAttribute(GOOGLE_PAY_BUTTON_CONFIG, payPalButtonConfigurationService.
                    parseGooglePayButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                            getGooglePayButtonStyleByPageType(BraintreePageType.CART)));
            model.addAttribute(APPLE_PAY_BUTTON_CONFIG, payPalButtonConfigurationService.
                            getApplePayButtonStyleByPageType(BraintreePageType.CART));
            model.addAttribute(GOOGLE_PAY_CART_DROP_IN_CONFIG, dropInConfigurationService
                .parseGooglePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                    .parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, CART)));
            model.addAttribute(PAYPAL_CART_DROP_IN_CONFIG, dropInConfigurationService
                .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                    .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, CART)));
            model.addAttribute(APPLE_PAY_CART_DROP_IN_CONFIG, dropInConfigurationService
                .parseApplePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                    .parsingJsonStringIntoApplePayDropInButtonStyleData(APPLE_PAY, CART)));
            model.addAttribute(B2B_SHOW_WARNING_MESSAGE_ON_EDIT_DROP_IN,
                brainTreeB2BOrderFacade.isCustomerHasActiveReplenishmentForSavedPayPalOrCreditCard());
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.SilentOrderPostPage.equals(viewName)) {
            fillPaymentMethodsInfo(model, BraintreePageType.MARK);
            model.addAttribute(PAYPAL_MARK_BUTTON_CONFIG, payPalButtonConfigurationService.
                parsePayPalButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                    getPayPalButtonStyleByPageType(BraintreePageType.MARK)));
            model.addAttribute(GOOGLE_PAY_BUTTON_CONFIG, payPalButtonConfigurationService.
                    parseGooglePayButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                            getGooglePayButtonStyleByPageType(BraintreePageType.MARK)));
            model.addAttribute(APPLE_PAY_BUTTON_CONFIG, payPalButtonConfigurationService.
                            getApplePayButtonStyleByPageType(BraintreePageType.MARK));
            model.addAttribute(GOOGLE_PAY_BILLING_DROP_IN_CONFIG, dropInConfigurationService
                .parseGooglePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                    .parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, BILLING)));
            model.addAttribute(PAYPAL_BILLING_DROP_IN_CONFIG, dropInConfigurationService
                .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                    .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, BILLING)));
            model.addAttribute(APPLE_PAY_BILLING_DROP_IN_CONFIG, dropInConfigurationService
                .parseApplePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                    .parsingJsonStringIntoApplePayDropInButtonStyleData(APPLE_PAY, BILLING)));
            model.addAttribute(B2B_SHOW_WARNING_MESSAGE_ON_EDIT_DROP_IN,
                brainTreeB2BOrderFacade.isCustomerHasActiveReplenishmentForSavedPayPalOrCreditCard());
            if (brainTreeConfigService.isLocalPaymentsEnabled()) {
                BraintreeUserData userData = brainTreeUserFacade.getUserData();
                model.addAttribute(USER_DATA, userData);
            }
            model.addAttribute(REGIONS, i18NFacade.getRegionsForCountryIso(US));
            model.addAttribute(CURRENT_DATE, new SimpleDateFormat("MM-dd-yyyy").format(new Date()));
            return SilentOrderPostPage;
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.CheckoutSummaryPage.equals(viewName)) {
            final BrainTreePaymentInfoData brainTreePaymentInfoData = brainTreePaymentFacade
                .getBrainTreePaymentInfoData();

            if (brainTreePaymentInfoData != null) {
                model.addAttribute(BRAIN_TREE_PAYMENT_DATA, brainTreePaymentInfoData);
                if (brainTreePaymentInfoData.getPaymentType().equals(US_BANK_ACCOUNT)) {
                    model.addAttribute(MERCHANT_NAME, brainTreeConfigService.getUsBankAccountMerchantName());
                }
            }
            if (brainTreeCheckoutFacade.getCheckoutCart() != null
                && brainTreeCheckoutFacade.getCheckoutCart().getPaymentInfo() != null
                && brainTreeCheckoutFacade.getCheckoutCart().getPaymentInfo().getSubscriptionId() != null) {
                String paymentProvider = brainTreeCheckoutFacade.getCheckoutCart().getPaymentInfo().getSubscriptionId();
                boolean isPayPal = BrainTreeUtils.isPayPalPayment(paymentProvider);
                model.addAttribute(IS_REPLENISHMENT_AVAILABLE, brainTreeConfigService.isStoreInVault()
                    && !(BrainTreeUtils.isIntentOrder(brainTreeConfigService.getIntent()) & isPayPal));
            } else {
                model.addAttribute(IS_REPLENISHMENT_AVAILABLE, brainTreeConfigService.isStoreInVault());
            }
            model.addAttribute(IS_STORE_IN_VAULT, brainTreeConfigService.isStoreInVault());
            return CheckoutSummaryPage;
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.CheckoutConfirmationPage
            .equals(viewName)) {
            final String orderCode = ((OrderData) model.get(ORDER_DATA)).getCode();
            if (isNotBlank(orderCode)) {
                final BrainTreePaymentInfoData brainTreePaymentInfoData = brainTreePaymentFacade
                    .getBrainTreePaymentInfoData(orderCode);
                if (brainTreePaymentInfoData != null) {
                    model.addAttribute(BRAIN_TREE_PAYMENT_DATA, brainTreePaymentInfoData);
                }
            }
            return CheckoutConfirmationPage;
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.ReplenishmentCheckoutConfirmationPage
            .equals(viewName)) {
            final String cartCode = ((ScheduledCartData) model.get(ORDER_DATA)).getCode();
            if (isNotBlank(cartCode)) {
                model.addAttribute(BRAIN_TREE_PAYMENT_DATA,
                    brainTreePaymentFacade.getBrainTreePaymentInfoDataByCart(cartCode));
            }
            return ReplenishmentCheckoutConfirmationPage;
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.AccountLayoutPage.equals(viewName)) {
            // add BRAIN_TREE_PAYMENT_DATA for order view page
            if (model.get(ORDER_DATA) instanceof ScheduledCartData) {
                final String cartCode = ((ScheduledCartData) model.get(ORDER_DATA)).getCode();
                if (isNotBlank(cartCode)) {
                    model.addAttribute(BRAIN_TREE_PAYMENT_DATA,
                        brainTreePaymentFacade.getBrainTreePaymentInfoDataByCart(cartCode));
                }
            } else {
                final OrderData orderData = (OrderData) model.get(ORDER_DATA);
                if (orderData != null && isNotBlank(orderData.getCode())) {
                    final String orderCode = orderData.getCode();
                    model.addAttribute(BRAIN_TREE_PAYMENT_DATA,
                        brainTreePaymentFacade.getBrainTreePaymentInfoData(orderCode));
                    return viewName;
                }
            }

            if (!isPaymentMethodsAvailable(viewName)) {
                return viewName;
            }

            final PayPalCheckoutData payPalCheckoutData = brainTreeCheckoutFacade.
                getPayPalCheckoutData(BraintreePageType.ACCOUNT);
            model.addAttribute(PAY_PAL_CHECKOUT_DATA, payPalCheckoutData);
            model.addAttribute(PAYMENT_INFOS, brainTreeUserFacade.getBrainTreeCCPaymentInfos(true));
            model.addAttribute(PAYPAL_BILLING_DROP_IN_CONFIG, dropInConfigurationService
                .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                    .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, BILLING)));
            model.addAttribute(GOOGLE_PAY_BUTTON_CONFIG, payPalButtonConfigurationService.
                    parseGooglePayButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                            getGooglePayButtonStyleByPageType(BraintreePageType.MARK)));
            model.addAttribute(B2B_SHOW_WARNING_MESSAGE_ON_EDIT_DROP_IN,
                brainTreeB2BOrderFacade.isCustomerHasActiveReplenishmentForSavedPayPalOrCreditCard());
            return ACCOUNT_LAYOUT_PAGE;
        } else if (B2C_CHECKOUT_CONFIRMATION_LAYOUT_PAGE.equals(viewName)) {
            if (model.get(ORDER_DATA) instanceof ScheduledCartData) {
                final String cartCode = ((ScheduledCartData) model.get(ORDER_DATA)).getCode();
                if (isNotBlank(cartCode)) {
                    model.addAttribute(BRAIN_TREE_PAYMENT_DATA,
                        brainTreePaymentFacade.getBrainTreePaymentInfoDataByCart(cartCode));
                }
            } else {
                final String orderCode = ((OrderData) model.get(ORDER_DATA)).getCode();
                if (isNotBlank(orderCode)) {
                    model.addAttribute(BRAIN_TREE_PAYMENT_DATA,
                        brainTreePaymentFacade.getBrainTreePaymentInfoData(orderCode));
                }
            }
            return viewName;
        } else if (B2C_ADD_TO_CART_POPUP_PAGE.equals(viewName)) {
            if (isPaymentMethodsAvailable(viewName)) {
                fillPaymentMethodsInfo(model, BraintreePageType.MINICART);
                model.addAttribute(IS_ANONYMOUS_USER, brainTreeUserFacade.isAnonymousUser());
                model.addAttribute(PAYPAL_BUTTON_CONFIG, payPalButtonConfigurationService.
                    parsePayPalButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                        getPayPalButtonStyleByPageType(BraintreePageType.MINICART)));
                model.addAttribute(GOOGLE_PAY_BUTTON_CONFIG, payPalButtonConfigurationService.
                        parseGooglePayButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                                getGooglePayButtonStyleByPageType(BraintreePageType.MINICART)));
                model.addAttribute(APPLE_PAY_BUTTON_CONFIG, payPalButtonConfigurationService.
                                getApplePayButtonStyleByPageType(BraintreePageType.MINICART));
                model.addAttribute(GOOGLE_PAY_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                    .parseGooglePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                        .parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, MINI_CART)));
                model.addAttribute(PAYPAL_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                    .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                        .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, MINI_CART)));
                model.addAttribute(APPLE_PAY_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                    .parseApplePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                        .parsingJsonStringIntoApplePayDropInButtonStyleData(APPLE_PAY, MINI_CART)));
                model.addAttribute(B2B_SHOW_WARNING_MESSAGE_ON_EDIT_DROP_IN,
                    brainTreeB2BOrderFacade.isCustomerHasActiveReplenishmentForSavedPayPalOrCreditCard());
                return Braintreeb2baddonControllerConstants.Views.Fragments.Cart.AddToCartPopup;
            }
            return viewName;
        } else if (B2C_CART_POPUP_PAGE.equals(viewName)) {
            if (isPaymentMethodsAvailable(viewName)) {
                fillPaymentMethodsInfo(model, BraintreePageType.MINICART);
                model.addAttribute(IS_ANONYMOUS_USER, brainTreeUserFacade.isAnonymousUser());
                model.addAttribute(PAYPAL_BUTTON_CONFIG, payPalButtonConfigurationService.
                    parsePayPalButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                        getPayPalButtonStyleByPageType(BraintreePageType.MINICART)));
                model.addAttribute(GOOGLE_PAY_BUTTON_CONFIG, payPalButtonConfigurationService.
                        parseGooglePayButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                                getGooglePayButtonStyleByPageType(BraintreePageType.MINICART)));
                model.addAttribute(APPLE_PAY_BUTTON_CONFIG, payPalButtonConfigurationService.
                                getApplePayButtonStyleByPageType(BraintreePageType.MINICART));
                model.addAttribute(GOOGLE_PAY_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                    .parseGooglePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                        .parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, MINI_CART)));
                model.addAttribute(PAYPAL_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                    .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                        .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, MINI_CART)));
                model.addAttribute(APPLE_PAY_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                    .parseApplePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                        .parsingJsonStringIntoApplePayDropInButtonStyleData(APPLE_PAY, MINI_CART)));
                model.addAttribute(B2B_SHOW_WARNING_MESSAGE_ON_EDIT_DROP_IN,
                    brainTreeB2BOrderFacade.isCustomerHasActiveReplenishmentForSavedPayPalOrCreditCard());
                return Braintreeb2baddonControllerConstants.Views.Fragments.Cart.CartPopup;
            }
            return viewName;
        } else if (B2C_CHECKOUT_DELIVERY_ADDRESS_PAGE.equals(viewName)
            && sessionService.getAttribute(BRAINTREE_GENERAL_ERROR_SHIPPING_ADDRESS) != null) {
            model.addAttribute("accErrorMsgs", sessionService.getAttribute(BRAINTREE_GENERAL_ERROR_SHIPPING_ADDRESS));
            sessionService.removeAttribute(BRAINTREE_GENERAL_ERROR_SHIPPING_ADDRESS);
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.FallbackPage.equals(viewName)) {
            model.addAttribute(CLIENT_TOKEN, brainTreeCheckoutFacade.generateClientToken(Boolean.TRUE));
            return FallbackPage;
        }
        return viewName;
    }

    private void fillPaymentMethodsInfo(final ModelMap model, BraintreePageType pageType) {
        ObjectMapper om = new ObjectMapper();
        final PayPalCheckoutData payPalCheckoutData = brainTreeCheckoutFacade.getPayPalCheckoutData(pageType);
        model.addAttribute(PAY_PAL_CHECKOUT_DATA, payPalCheckoutData);
        List<CCPaymentInfoData> brainTreeCCPaymentInfos = brainTreeUserFacade.getBrainTreeCCPaymentInfos(true);
        model.addAttribute("payPalShouldBeSaved", !isPayPalAccountSaved(brainTreeCCPaymentInfos));
        model.addAttribute(PAYMENT_INFOS, brainTreeCCPaymentInfos);
        if (pageType.equals(BraintreePageType.MARK)) {
            List<String> lpmids = new ArrayList<>();
            for (BraintreeLocalPaymentMethodData lpm :
                payPalCheckoutData.getLocalPaymentMethod().getLocalPaymentMethods()) {
                lpmids.add(lpm.getCode());
            }
            try {
                model.addAttribute(LPM_IDS, om.writeValueAsString(lpmids));
            } catch (IOException e) {
                LOG.error("Error during write value", e);
            }
        }
    }

    private boolean isPayPalAccountSaved(List<CCPaymentInfoData> savedPayments) {
        for (CCPaymentInfoData payment : savedPayments) {
            if (BrainTreeUtils.isPayPalPayment(payment.getSubscriptionId())) {
                return true;
            }
        }
        return false;
    }

    private boolean isPaymentMethodsAvailable(String viewName) {
        if (B2C_CART_POPUP_PAGE.equals(viewName) || B2C_ADD_TO_CART_POPUP_PAGE.equals(viewName)) {
            return isPaymentMethodsAvailableForCartPopup();
        } else if (ACCOUNT_LAYOUT_PAGE.equals(viewName)) {
            if (brainTreeConfigService.isDropInEnabled()) {
                return brainTreeConfigService.isPayPalStandardEnabled() || brainTreeConfigService
                    .isHostedFieldEnabled();
            } else {
                return isPaymentMethodsAvailableForAccountLayout();
            }
        } else {
            return brainTreeConfigService.isOneOfPaymentMethodsEnabled();
        }
    }

    private boolean isPaymentMethodsAvailableForAccountLayout() {
        return brainTreeConfigService.isHostedFieldEnabled() || brainTreeConfigService.isSrcEnabled()
                || isAvailableAccountPaymentMethods();
    }

    private boolean isAvailableAccountPaymentMethods() {
        return (brainTreeConfigService.isPayPalStandardEnabled()
            && !BrainTreeUtils.isIntentOrder(brainTreeConfigService.getIntent()))
                || brainTreeConfigService.isVenmoEnabled() || brainTreeConfigService.isGooglePayEnabled();
    }

    private boolean isPaymentMethodsAvailableForCartPopup() {
        return brainTreeConfigService.isPayPalExpressEnabled() || brainTreeConfigService.isApplePayEnabled()
                || brainTreeConfigService.isGooglePayEnabled() || brainTreeConfigService.isCreditEnabled();
    }

    private void registerConfigChangeLister() {
        final ConfigIntf config = Registry.getMasterTenant().getConfig();
        configurationChangeListener = new BrainTreeConfigurationListener();
        config.registerConfigChangeListener(configurationChangeListener);
    }


    public BrainTreeButtonConfigurationService getPayPalButtonConfigurationService() {
        return payPalButtonConfigurationService;
    }

    public void setPayPalButtonConfigurationService(
        BrainTreeButtonConfigurationService payPalButtonConfigurationService) {
        this.payPalButtonConfigurationService = payPalButtonConfigurationService;
    }
}
