/**
 *
 */
package com.braintree.setup;

import de.hybris.platform.addonsupport.setup.impl.DefaultAddonSampleDataImportService;
import de.hybris.platform.core.initialization.SystemSetupContext;

/**
 * This class extends DefaultAddonSampleDataImportService and override importContentCatalog method
 */
public class BraintreeSampleDataImportService extends DefaultAddonSampleDataImportService
{

    @Override
    protected void importContentCatalog(SystemSetupContext context, String importRoot, String catalogName)
    {
        if ("electronics".equals(catalogName) || "apparel-uk".equals(catalogName)  || "powertools".equals(catalogName))
        {
            importImpexFile(context, importRoot + "/contentCatalogs/" + catalogName + "ContentCatalog/email-content.impex", false);
            synchronizeContentCatalog(context, catalogName, true);
        }
    }
}
