package com.braintree.validator;

import de.hybris.platform.acceleratorstorefrontcommons.forms.UpdatePasswordForm;
import org.apache.commons.lang.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class BrainTreePasswordValidator implements Validator {

    @Override
    public boolean supports(Class<?> clazz) {
        return UpdatePasswordForm.class.equals(clazz);
    }

    @Override
    public void validate(Object target, Errors errors) {
        UpdatePasswordForm passwordForm = (UpdatePasswordForm) target;
        String newPasswd = passwordForm.getNewPassword();
        String checkPasswd = passwordForm.getCheckNewPassword();

        if (StringUtils.isEmpty(newPasswd)) {
            errors.rejectValue("newPassword", "updatePwd.pwd.invalid");
        } else if (StringUtils.length(newPasswd) < 6 || StringUtils.length(newPasswd) > 255) {
            errors.rejectValue("newPassword", "updatePwd.pwd.invalid");
        }

        if (StringUtils.isEmpty(checkPasswd)) {
            errors.rejectValue("checkNewPassword", "updatePwd.pwd.invalid");
        } else if (StringUtils.length(checkPasswd) < 6 || StringUtils.length(checkPasswd) > 255) {
            errors.rejectValue("checkNewPassword", "updatePwd.pwd.invalid");
        }
    }
}
