export const braintree = {
  error: {
    provider: 'Error during connect with payment provider. Reason: {{ reason }}',
    invalidCard: 'Invalid card data',
    invalidUsBankAccount: 'Invalid payment details',
    unsecuredCard: 'This card is unsecured. You should use another payment method.',
    authorization: {
      client: 'Error during connect with payment provider. Reason: Authorization failed.',
      failed: 'We are sorry but your transaction could not be completed at this time; please try again later or contact customer service at 555-555-5555'
    },
    unverified_account: 'Please use another login or confirm email address',
    address: {
      provide: 'You must provide a delivery address in order to go to the next step.'
    },
    failedVerificationErrorMessage: 'There was a problem processing your payment. Please verify your payment information and try again.',
    failedCVVVerificationErrorMessage: 'CVV verification failed. Please re-enter a CVV.',
    client_request_timeout: 'Request timed out waiting for a reply.',
    client_gateway_network: 'Cannot contact the gateway at this time.',
    client_request_error: 'There was a problem with your request.',
    client_missing_gateway_configuration: 'Missing gatewayConfiguration.',
    paypal_account_tokenization_failed: 'Could not tokenize user\'s PayPal account.',
    paypal_invalid_payment_option: 'PayPal payment options are invalid',
    paypal_flow_failed: 'Could not initialize PayPal flow',
    paypal_browser_not_supported: 'This browser is not',
    paypal_flow_option_required: 'PayPal flow property is invalid or missing.',
    lpm_payment_failed: 'Sorry, we weren\'t able to complete your payment',
    lpm_window_open_failed: 'Local Payment Method dialog box is blocked by this web browser! Please go to the phone settings and allow using pop-ups in your web browser.',
    braintree_delete_payment_details_with_not_captured_order: 'Sorry, but you can\'t delete this payment method, since there are created transactions which are waiting for capturing. When all the transactions will be captured, then you will be able to remove this payment method',
    braintree_message_no_shipping_address: 'Sorry, but you can\'t place an order from this page, since you don\'t have a saved shipping address. Please place this order on the Billing page or save a shipping address in order to place the order on this page.',
    braintree_myaccount_text_dropin_limited_delete_payment_methods: 'Sorry, but you can\'t delete  payment methods, since there are created transactions which are waiting for capturing. When all the transactions will be captured, then you will be able to remove payment methods',
    lpm_invalid_currency: 'Sorry, this payment method can`t be used for this purchase due to the incorrect currency for funding source',
    lpm_invalid_county: 'Sorry, this payment method can`t be used for this purchase due to the unsupported country in the shipping options',
    customerAlreadyExist: 'An account already exists for this email address.'
  },
  warning: {
    warningMessageAboutReplenishmentDropIn: 'Please pay attention to the fact that in case you remove the payment method which is linked to the active replenishment, then this replenishment will be canceled'
  },
  paymentDetails: {
    usBankAccountOneTimeMessage: 'By clicking Continue, I authorize Braintree, a service of PayPal, on behalf of {{ merchantName }} to verify my bank account information using bank information and consumer reports and I authorize {{ merchantName }} to initiate an ACH/electronic debit to my checking/savings account,' +
        ' Depository Name: {{ depositoryName }}, Routing Number: {{ routingNumber }} and Account Number: {{ accountNumber }}, in the amount of {{ price }} on {{ date }}. I agree the ACH transactions I authorize comply with all applicable law.',
    usBankAccountSavedMessage: 'By clicking Continue, I authorize Braintree, a service of PayPal, on behalf of {{ merchantName }} to verify my bank account information using bank information and consumer reports and I authorize {{ merchantName }} to initiate an ACH/electronic debit to my checking/savings account,' +
        ' Depository Name: {{ depositoryName }}, Routing Number: {{ routingNumber }} and Account Number: {{ accountNumber }}, that will be stored on file, and debited on or after the due date. I agree the ACH transactions I authorize comply with all applicable law.\n' +
        'I understand that this authorization will remain in full force and effect until I notify {{ merchantName }} that I wish to revoke this authorization.',
    usBankAccountLast4SavedMessage: 'By clicking Place Order, I authorize Braintree, a service of PayPal, on behalf of {{ merchantName }} to verify my bank account information using bank information and consumer reports and I authorize {{ merchantName }} to initiate an ACH/electronic debit to my checking/savings account,' +
        ' Depository Name: {{ firstName }} {{ lastName }}, Routing Number: {{ routingNumber }} and Account Number(last 4): {{ accountNumber }}, that will be stored on file, and debited on or after the due date. I agree the ACH transactions I authorize comply with all applicable law.\n' +
        'I understand that this authorization will remain in full force and effect until I notify {{ merchantName }} that I wish to revoke this authorization.',
    save: 'Save Payment Info',
    add: 'Add Payment Details',
    paymentDetails: 'Payment Details',
    cancelCreation: 'Back to Payment Details',
    noSaved: 'No Saved Payment Details',
    defaultPaymentMethod: 'Default Payment Method',
    noPaymentDetailsAvailable: 'No payment methods available',
    isNotRequiredForVenmo: 'Is not required for Venmo',
    secureRemoteCommerce: 'Buy with Secure Remote Commerce',
    paymentMethodUpdated: 'Payment method updated successfully',
    sameAddressAlreadySaved: 'New Billing Address can\'t be saved since it is the same as already saved',
    userHaveExpiredCardMessage: 'Please note that you have a credit card in your wallet that is expired. You will not be able to place the order with this credit card',
    userHaveExpiredSoonCardMessage: 'Please note that you have a credit card in your wallet that is going to expire soon. Please check it.',
    verifyCVVInputLabel: 'Please enter a CVV in order to verify this card and place the order',
    accountNumberLast4: 'Account Number(Last4): '
  },
  dropIn: {
    dropInSubmitButton: 'Purchase',
    dropInSaveButton: 'Save',
    myAccount: {
      payingWith: 'List of saved payment methods',
      chooseAWayToPay: 'Choose payment method to save',
      chooseAnotherWayToPay: 'Choose other payment method to save',
      payWithCard: 'Saving a card'
    }
  },
  orderDetails: {

    orderId: 'Order #',
    replenishmentId: 'Replenishment #',
    purchaseOrderId: 'Purchase Order #',
    emptyPurchaseOrderId: 'None',
    none: 'None {{value}}',
    placed: 'Placed',
    placedBy: 'Placed By',
    unit: 'Unit',
    costCenter: 'Cost Center',
    costCenterAndUnit: 'Cost Center / Unit',
    costCenterAndUnitValue: '{{costCenterName}} / {{unitName}}',
    payByAccount: 'Pay by Account',
    paidByCreditCard: '(paid by credit card)',
    status: 'Status',
    shippedOn: 'Shipped on',
    startOn: 'Start On',
    nextOrderDate: 'Next Order Date',
    frequency: 'Frequency',
    cancelled: ' Cancelled',
    deliveryStatus_IN_TRANSIT: 'In Transit',
    deliveryStatus_READY_FOR_PICKUP: 'Ready for Pickup',
    deliveryStatus_READY_FOR_SHIPPING: 'Ready for Shipping',
    deliveryStatus_WAITING: 'Waiting',
    deliveryStatus_DELIVERING: 'Delivering',
    deliveryStatus_PICKPACK: 'Preparing for Shipment',
    deliveryStatus_PICKUP_COMPLETE: 'Pickup Complete',
    deliveryStatus_DELIVERY_COMPLETED: 'Delivery Complete',
    deliveryStatus_PAYMENT_NOT_CAPTURED: 'Payment Issue',
    deliveryStatus_READY: 'In Process',
    deliveryStatus_DELIVERY_REJECTED: 'Delivery Rejected',
    deliveryStatus_SHIPPED: 'Shipped',
    deliveryStatus_TAX_NOT_COMMITTED: 'Tax Issue',
    deliveryStatus_CANCELLED: 'Cancelled',
    statusDisplay_cancelled: 'Cancelled',
    statusDisplay_cancelling: 'Cancel Pending',
    statusDisplay_completed: 'Completed',
    statusDisplay_created: 'Created',
    statusDisplay_error: 'Pending',
    statusDisplay_Error: 'Pending',
    statusDisplay_processing: 'Pending',
    statusDisplay_open: 'Open',
    statusDisplay_pending: {
      approval: 'Pending Approval',
      merchant: {
        approval: 'Pending Merchant Approval',
      },
    },
    statusDisplay_approved: 'Approved',
    statusDisplay_rejected: 'Rejected',
    statusDisplay_merchant: {
      approved: 'Merchant Approved',
      rejected: 'Merchant Rejected',
    },
    statusDisplay_assigned: {
      admin: 'Assigned To Administrator',
    },
    consignmentTracking: {
      action: 'Track package',
      dialog: {
        header: 'Tracking Information',
        shipped: 'Shipped',
        estimate: 'Estimated Delivery',
        carrier: 'Delivery Service',
        trackingId: 'Tracking Number',
        noTracking:
            'The package has not been dispatched from the warehouse. The tracking information will be available after the package is shipped.',
        loadingHeader: 'Consignment Tracking',
      },
    },
    cancellationAndReturn: {
      returnAction: 'Request a Return',
      cancelAction: 'Cancel Items',
      item: 'Item',
      itemPrice: 'Item Price',
      quantity: 'Max Quantity',
      returnQty: 'Quantity to Return',
      cancelQty: 'Quantity to Cancel',
      setAll: 'Set all quantities to maximum',
      totalPrice: 'Total',
      submit: 'Submit Request',
      returnSuccess: 'Your return request ({{rma}}) was submitted',
      cancelSuccess:
          'Your cancellation request was submitted (original order {{orderCode}} will be updated)',
    },
    cancelReplenishment: {
      title: 'Cancel Replenishment',
      description: 'Cancel any future replenishment order?',
      accept: 'Yes',
      reject: 'No',
      cancelSuccess:
          'Replenishment order #{{replenishmentOrderCode}} has been successfully cancelled',
    },
    statusDisplay_reversed: 'Local Payment Reversed',
  },
  address: {
    addresses: 'Addresses',
    select: 'Select address',
  }
};
