import {Component, Input, OnInit} from '@angular/core';
import {OccConfig, PaymentDetails,RoutingService} from '@spartacus/core';
import {Observable} from 'rxjs';
import {CheckoutData, paymentText} from 'braintree-spartacus-core';
import {CardComponent} from '@spartacus/storefront';
import {BraintreePaymentDetailsService, BraintreePaymentDetails, BraintreeHostedFieldsCheckoutService, BraintreeAssets} from 'braintree-spartacus-core';
import {Router} from '@angular/router';
import {ActivatedRoute} from '@angular/router';
import {CheckoutStepService} from '@spartacus/checkout/components';

@Component({
  selector: 'bt-payment-info',
  templateUrl: './braintree-payment-info.component.html'
})
export class BraintreePaymentInfoComponent extends CardComponent implements OnInit {
  contextPath$: string;
  braintreeAssets$: Observable<BraintreeAssets>;

  paymentText = paymentText;
  expiresIn = 'Expires in ';
  monthSingular = " month";
  monthPlural = " months";

  @Input()
  editMode = false;

  @Input()
  currentPaymentMethod: PaymentDetails;

  @Input()
  paymentDetails: BraintreePaymentDetails;

  @Input()
  title: Observable<string>;

  @Input()
  expirationStatus: string;

  @Input()
  reminderMonthToExpire: number;

  @Input()
  checkoutData: CheckoutData;


  constructor(
    protected checkoutStepService: CheckoutStepService,
    protected activatedRoute: ActivatedRoute,
    protected hostedFieldsCheckoutService: BraintreeHostedFieldsCheckoutService,
    protected braintreePaymentDetailsService: BraintreePaymentDetailsService,
    protected config: OccConfig,
    protected router: Router,
    protected routingService: RoutingService
  ) {
    super();
  }

  ngOnInit(): void {
    this.contextPath$ = this.config.backend.occ.baseUrl;
    this.braintreeAssets$ = this.braintreePaymentDetailsService.getBraintreeAssets();
  }

  updateBillingAddress(): void{
    const paymentMethodId = this.paymentDetails.id;
    this.router.navigate(['/updatePaymentMethod'], {queryParams :{paymentMethodId:paymentMethodId}});
  }

  onSubmitCVVCheck() {
  this.hostedFieldsCheckoutService.tokenizeCVVVerification(this.paymentDetails, this.checkoutData, this.activatedRoute);
  }
}
