import {Component} from '@angular/core';
import {
  ActiveCartService,
  TranslationService,
  UserAddressService,
  UserCostCenterService,
} from '@spartacus/core';
import {
  PaymentTypeFacade,
} from '@spartacus/checkout/root'
import {
  CheckoutCostCenterFacade,
  CheckoutDeliveryFacade,
  CheckoutPaymentFacade,
} from '@spartacus/checkout/root';

import {Card} from '@spartacus/storefront';
import {CheckoutStepService, ReviewSubmitComponent} from '@spartacus/checkout/components';
import {Observable} from 'rxjs';
import { BraintreePaymentMethodsUtilsService, BraintreePaymentDetails } from 'braintree-spartacus-core';

@Component({
  selector: 'bt-review-order',
  templateUrl: './braintree-review-order.component.html'
})
export class BraintreeReviewOrderComponent extends ReviewSubmitComponent {
  title$: Observable<string>;
  constructor(
    protected checkoutDeliveryService: CheckoutDeliveryFacade,
    protected checkoutPaymentService: CheckoutPaymentFacade,
    protected userAddressService: UserAddressService,
    protected activeCartService: ActiveCartService,
    protected translation: TranslationService,
    protected checkoutStepService: CheckoutStepService,
    protected paymentTypeService: PaymentTypeFacade,
    protected checkoutCostCenterService: CheckoutCostCenterFacade,
    protected userCostCenterService: UserCostCenterService,
    protected braintreePaymentMethodsUtilsService: BraintreePaymentMethodsUtilsService
  ) {
    super(checkoutDeliveryService, checkoutPaymentService, userAddressService, activeCartService, translation,
      checkoutStepService, paymentTypeService, checkoutCostCenterService, userCostCenterService);
    this.title$ = this.translation.translate('paymentForm.payment');
  }


  getPaymentMethodCardBraintree(paymentDetails: BraintreePaymentDetails): Observable<Card> {
    return this.braintreePaymentMethodsUtilsService.getPaymentMethodCardBraintreeReviewOrder(paymentDetails);
  }
}
