import {Component, OnInit} from '@angular/core';
import {Observable} from "rxjs";
import {BraintreePaymentDetailsService, CheckoutData} from "braintree-spartacus-core";
import {ORDER_TYPE, PaymentDetails} from "@spartacus/core";
import {CheckoutFacade, CheckoutPaymentFacade} from "@spartacus/checkout/root";


@Component({
    selector: 'bt-replenishment-usBankAccount',
    templateUrl: './braintree-replenishment-usBankAccount.component.html',
})
export class BraintreeReplenishmentUsBankAccountComponent implements OnInit {

    checkoutData$: Observable<CheckoutData>;
    payPalDetails$: Observable<PaymentDetails>;
    orderTypes = ORDER_TYPE;
    selectedOrderType$: Observable<ORDER_TYPE> = this.checkoutService.getCurrentOrderType();

    constructor(
        protected braintreePaymentDetailsService: BraintreePaymentDetailsService,
        protected checkoutPaymentService: CheckoutPaymentFacade,
        protected checkoutService: CheckoutFacade,
    ) {
    }
    ngOnInit(): void {
        this.checkoutData$ = this.braintreePaymentDetailsService
            .loadPaymentDetails('usbankaccount')
            .pipe();
        this.payPalDetails$ = this.checkoutPaymentService.getPaymentDetails();
    }
}