import {ChangeDetectionStrategy, Component, OnDestroy, OnInit} from '@angular/core';
import {Observable} from 'rxjs';
import {map, tap} from 'rxjs/operators';
import {ActiveCartService, Cart, Order, ORDER_TYPE} from '@spartacus/core';
import {CheckoutFacade} from '@spartacus/checkout/root';

@Component({
    selector: 'bt-order-confirmation-thank-you-message',
    templateUrl: './braintree-order-confirmation-thank-you-message.component.html',
    changeDetection: ChangeDetectionStrategy.OnPush
})
export class BraintreeOrderConfirmationThankYouMessageComponent implements OnInit, OnDestroy {

    order$: Observable<any>;
    cart$: Observable<Cart>;
    isReplenishmentOrderType$: Observable<boolean>;
    isGuestCustomer = false;
    orderGuid: string;
    email: string;

    constructor(protected checkoutService: CheckoutFacade,
                protected activeCartService: ActiveCartService) {}

    ngOnInit() {
        this.order$ = this.checkoutService.getOrderDetails().pipe(
            tap((order) => {
                this.isGuestCustomer =
                    'guestCustomer' in order ? order.guestCustomer ?? false : false;
                this.orderGuid = order.guid as string;
            })
        );

        this.cart$ = this.activeCartService.getActive();

        this.isReplenishmentOrderType$ = this.checkoutService.getCurrentOrderType()
            .pipe(
                map(
                    (orderType) => ORDER_TYPE.SCHEDULE_REPLENISHMENT_ORDER === orderType
                )
            );
    }

    ngOnDestroy() {
        this.checkoutService.clearCheckoutData();
    }

}
