import {ChangeDetectorRef, Component, ElementRef, EventEmitter, Input, OnInit, Output, ViewChild} from '@angular/core';
import {
  BraintreeCheckoutService,
  BraintreeDropInService,
  BraintreePaymentMethodsUtilsService,
  CheckoutData, INTENT_ORDER,
  PageType
} from 'braintree-spartacus-core';
import {GlobalMessageService, GlobalMessageType} from '@spartacus/core';

@Component({
  selector: 'bt-myaccount-drop-in',
  templateUrl: './braintree-myaccount-drop-in.component.html'
})
export class BraintreeMyaccountDropInComponent implements OnInit {

  @Input()
  checkoutData: CheckoutData;

  @Input()
  isAvailableAddPaymentMethod: boolean;

  @Output()
  backToPaymentMethods = new EventEmitter<any>();

  @ViewChild('dropInButtonContainer') dropInButton: ElementRef;
  @ViewChild('dropInSubmitButton') dropInSubmitButton: ElementRef;

  pageType = PageType.MY_ACCOUNT;

  isAvailableSavedPaymentMethods = false;
  isDropInLoaded = false;
  isCurrentPaymentMethodCard = false;

  constructor(
      protected braintreeDropInService: BraintreeDropInService,
      protected braintreeCheckoutService: BraintreeCheckoutService,
      protected globalMessageService: GlobalMessageService,
      protected paymentMethodsUtilsService: BraintreePaymentMethodsUtilsService,
      private cdr: ChangeDetectorRef
  ) {
  }

  ngOnInit(): void {
    this.paymentMethodsUtilsService.setBackToPaymentMethods(this.backToPaymentMethods);

    if (this.isAvailableAddPaymentMethod && (this.checkoutData.configurationData.intent === INTENT_ORDER)) {
      this.checkoutData.payPalPaymentMethod.payPalStandardEnabled = false;
    }

    if (this.checkoutData.payPalPaymentMethod.payPalStandardEnabled || this.checkoutData.creditCardPaymentMethod.hostedFieldsEnable) {
      this.braintreeDropInService.getDropInButtonStyle('Billing').subscribe(styles => {
        this.braintreeDropInService.initializeDropIn(this.dropInButton.nativeElement, this.dropInSubmitButton.nativeElement,
            this.checkoutData, styles, this.pageType, (dropInInstance) => {

              this.isDropInLoaded = true;

              if (dropInInstance._model._paymentMethods.length > 0) {
                this.isAvailableSavedPaymentMethods = true;

                if (this.checkoutData.dropIn.isLimitedDeletePaymentMethods) {
                  this.globalMessageService.add(
                    {key: 'error.braintree_myaccount_text_dropin_limited_delete_payment_methods'},
                    GlobalMessageType.MSG_TYPE_INFO, 10000
                  );
                }
              }

              dropInInstance.on('changeActiveView', (event) => {
                if (dropInInstance._model._paymentMethods.length === 0) {
                  this.isAvailableSavedPaymentMethods = false;
                }
                if (event.newViewId === 'methods' && this.isAvailableAddPaymentMethod) {
                  if (dropInInstance._model._activePaymentMethod != null && event.previousViewId === 'paypal') {

                    dropInInstance.requestPaymentMethod((err, payload) => {
                      if (err) {
                        console.log(err);
                        this.showErrorMessage(err.message);
                        return;
                      }
                      this.braintreeCheckoutService.processPayPalResponse(
                          payload,
                          false,
                          payload.deviceData,
                          PageType.MY_ACCOUNT
                      );
                      this.backToPaymentMethods.emit();
                    });
                  }
                  this.changeCorrectView(dropInInstance);
                }
                this.isCurrentPaymentMethodCard = event.newViewId === 'card';
                this.cdr.detectChanges();
              });

              if (this.isAvailableAddPaymentMethod) {
                dropInInstance.clearSelectedPaymentMethod();
                this.changeCorrectView(dropInInstance);
              }
              this.cdr.detectChanges();
            });
      });
    } else {
      this.isDropInLoaded = true;
    }
  }

  private changeCorrectView(dropInInstance: any): void {
    if (dropInInstance._model.supportedPaymentOptions.length > 1) {
      dropInInstance._mainView.setPrimaryView('options', undefined);
    } else {
      dropInInstance._mainView.setPrimaryView(dropInInstance._model.supportedPaymentOptions[0], undefined);
    }
  }

  private showErrorMessage(message): void {
    this.globalMessageService.add(
        {
          key: message,
        },
        GlobalMessageType.MSG_TYPE_ERROR
    );
  }


  isOnePaymentMethodAvailable(checkoutData: CheckoutData): boolean {
    const payPalStandardEnabled = checkoutData.payPalPaymentMethod.payPalStandardEnabled;
    const hostedFieldsEnable = checkoutData.creditCardPaymentMethod.hostedFieldsEnable;
    return (payPalStandardEnabled && !hostedFieldsEnable) || (hostedFieldsEnable && !payPalStandardEnabled);
  }

  back(): void {
    this.backToPaymentMethods.emit();
  }
}
