import {ModuleWithProviders, NgModule} from '@angular/core';
import {CmsConfig, ConfigModule, I18nModule, provideConfig, UrlModule, AuthGuard} from '@spartacus/core';
import {RouterModule, Routes} from '@angular/router';
import {
  BraintreeAddPaymentMethodMyaccountComponent,
  BraintreeAddressComponent,
  BraintreeBillingComponent,
  BraintreeCartComponent,
  BraintreeCartTotalsComponent,
  BraintreeHostedFieldsComponent,
  BrainTreeUsBankAccountComponent,
  BraintreeOrderConfirmationComponent,
  BraintreeOrderDetailShippingComponent,
  BraintreeOrderOverviewComponent,
  BraintreePaymentInfoComponent,
  BraintreePaymentMethodComponent,
  BraintreePaymentMethodsMyaccountComponent,
  BraintreeReviewOrderComponent,
  BraintreeSelectAddressMyaccountComponent,
  PaypalCreditMessageComponent,
  BraintreeDropInComponent,
  LPMFallbackComponent, BraintreeReplenishmentOrderComponent,
  BraintreeCartDropInComponent,
  BraintreeMyaccountDropInComponent,
  BraintreeEditBillingAddressForPaymentMethodMyaccountComponent, BraintreeReplenishmentUsBankAccountComponent
} from './components/index';
import {FormsModule, ReactiveFormsModule} from '@angular/forms';
import {
  AddressBookModule,
  AddressFormModule,
  CardModule,
  CartSharedModule,
  CmsPageGuard,
  FormErrorsModule,
  IconModule,
  OrderOverviewModule,
  PromotionsModule, PwaModule, 
  SpinnerModule
} from '@spartacus/storefront';
import {
  CheckoutAuthGuard,
  OrderConfirmationGuard,
  CartNotEmptyGuard,
  OrderConfirmationModule,
  ShippingAddressModule,
  ScheduleReplenishmentOrderModule
} from '@spartacus/checkout/components';
import {NgSelectModule} from '@ng-select/ng-select';
import {CommonModule} from '@angular/common';
import {BraintreeCoreModule} from 'braintree-spartacus-core';
import {BraintreeCheckoutConfig} from './config/braintree-checkout-config';
import {BraintreeOrderConfirmationThankYouMessageComponent} from './components/order/braintree-order-confirmation-thank-you-message/braintree-order-confirmation-thank-you-message.component';
import {braintreeTranslationChunksConfig, braintreeTranslations} from "./translations";
import {OrderDetailsService, ReplenishmentOrderDetailsService} from "@spartacus/order/components";
import {PaypalConnectComponent} from "./components/login-page/paypal-connect/paypal-connect.component";
import {PaypalConnectWaitingComponent} from './components/login-page/paypal-connect/paypal-connect-waiting/paypal-connect-waiting.component';
import {PaypalConnectAdditionalComponent} from './components/login-page/paypal-connect/paypal-connect-additional/paypal-connect-additional.component';
import {BraintreeSetUpPasswordForSingleAuthComponent} from "./components/my-account/braintree-set-up-password-for-single-auth/braintree-set-up-password-for-single-auth.component";
import {LoginFormComponentService, LoginFormModule} from "@spartacus/user/account/components";
import {BraintreeLoginFormComponentService} from "./components/login-page/paypal-connect/login-form-component.service";

const staticRoutes: Routes =
    [{
      path: 'localPaymentMethods/fallback',
      component: LPMFallbackComponent,
      data: {pageLabel: 'order'},
      canActivate: [CmsPageGuard]
}];

@NgModule({
  declarations: [
    BraintreeCartComponent,
    BraintreePaymentMethodComponent,
    BraintreeCartTotalsComponent,
    BraintreeHostedFieldsComponent,
    BrainTreeUsBankAccountComponent,
    LPMFallbackComponent,
    BraintreePaymentMethodsMyaccountComponent,
    BraintreeAddPaymentMethodMyaccountComponent,
    BraintreeMyaccountDropInComponent,
    BraintreeSelectAddressMyaccountComponent,
    BraintreeAddressComponent,
    BraintreeReviewOrderComponent,
    BraintreePaymentInfoComponent,
    BraintreeOrderOverviewComponent,
    BraintreeOrderDetailShippingComponent,
    BraintreeOrderConfirmationComponent,
    BraintreeBillingComponent,
    PaypalCreditMessageComponent,
    BraintreeReplenishmentOrderComponent,
    BraintreeReplenishmentUsBankAccountComponent,
    BraintreeOrderConfirmationThankYouMessageComponent,
    BraintreeDropInComponent,
    BraintreeCartDropInComponent,
    PaypalConnectComponent,
    BraintreeEditBillingAddressForPaymentMethodMyaccountComponent,
    PaypalConnectWaitingComponent,
    PaypalConnectAdditionalComponent,
    BraintreeSetUpPasswordForSingleAuthComponent
  ],
  imports: [
    BraintreeCoreModule,
    CommonModule,
    RouterModule.forChild(staticRoutes),
    ConfigModule.withConfig({
      cmsComponents: {
        ReturningCustomerLoginComponent:{
          providers: [
            {
              provide: LoginFormComponentService,
              useClass: BraintreeLoginFormComponentService,
            },
          ],
        },
        OrderConfirmationThankMessageComponent: {
          component: BraintreeOrderConfirmationThankYouMessageComponent,
          guards: [OrderConfirmationGuard],
        },
        ReplenishmentConfirmationMessageComponent: {
          component: BraintreeOrderConfirmationThankYouMessageComponent,
          guards: [OrderConfirmationGuard],
        },
        OrderConfirmationOverviewComponent: {
          component: BraintreeOrderConfirmationComponent,
          guards: [OrderConfirmationGuard],
        },
        ReplenishmentConfirmationOverviewComponent: {
          component: BraintreeOrderConfirmationComponent,
          guards: [OrderConfirmationGuard],
        },
        PayPalCreditMessageComponentSPA: {
          component: PaypalCreditMessageComponent
        },
        AccountPaymentDetailsComponent: {
          component: BraintreePaymentMethodsMyaccountComponent
        },
        CheckoutPaymentDetails: {
          component: BraintreeBillingComponent
        },
        CheckoutReviewOrder: {
          component: BraintreeReviewOrderComponent
        },
        CartTotalsComponent: {
          component: BraintreeCartTotalsComponent
        },
        CheckoutScheduleReplenishmentOrder: {
          component: BraintreeReplenishmentOrderComponent,
          guards: [CheckoutAuthGuard, CartNotEmptyGuard],
        },
        ReplenishmentDetailShippingComponent: {
          component: BraintreeOrderDetailShippingComponent,
          providers: [
            {
              provide: OrderDetailsService,
              useExisting: ReplenishmentOrderDetailsService,
            },
          ],
        },
        OrderApprovalDetailShippingComponent: {
          component: BraintreeOrderDetailShippingComponent,
        },
        AccountOrderDetailsShippingComponent: {
          component: BraintreeOrderDetailShippingComponent,
        },
        PayPalConnectButtonComponentSPA: {
          component: PaypalConnectComponent
        },
        BraintreeEditBillingAddressForPaymentMethodMyaccountComponent: {
          component: BraintreeEditBillingAddressForPaymentMethodMyaccountComponent,
          guards: [AuthGuard]
        },
        PayPalConnectAdditionalComponentB2C: {
          component: PaypalConnectWaitingComponent
        },
        PayPalConnectAdditionalComponentB2B: {
          component: PaypalConnectAdditionalComponent
        },
        UpdatePasswordComponent: {
          component: BraintreeSetUpPasswordForSingleAuthComponent,
          guards: [AuthGuard],
        },
        BraintreeReplenishmentUsBankAccountComponentB2B: {
          component: BraintreeReplenishmentUsBankAccountComponent
        }
      }
    } as CmsConfig),
    FormsModule,
    I18nModule,
    UrlModule,
    CardModule,
    IconModule,
    PromotionsModule,
    CartSharedModule,
    FormErrorsModule,
    NgSelectModule,
    ShippingAddressModule,
    AddressFormModule,
    AddressBookModule,
    ReactiveFormsModule,
    OrderOverviewModule,
    SpinnerModule,
    PwaModule,
      LoginFormModule,
    OrderConfirmationModule,
    ScheduleReplenishmentOrderModule
  ],
  entryComponents: [BraintreePaymentMethodComponent, BraintreeReviewOrderComponent, BraintreeDropInComponent],
  exports: [
      BraintreePaymentMethodComponent,
    BraintreeReviewOrderComponent,
    PaypalCreditMessageComponent,
    BraintreeDropInComponent,
  ],
})
export class BraintreeStorefrontModule {
  static withConfig(
      config?: BraintreeCheckoutConfig
  ): ModuleWithProviders<BraintreeStorefrontModule> {
    return {
      ngModule: BraintreeStorefrontModule,
      providers: [
        provideConfig(config),
        provideConfig({
        i18n: {
          resources: braintreeTranslations,
          chunks: braintreeTranslationChunksConfig,
          fallbackLang: 'en',
        }}),
      ],
    };
  }
}
